﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using mshtml;
using System.Windows.Forms;
using System.Threading;
using System.IO;

using nispi.controlclass;

namespace nispi.WriteToThread
{
    class PostData
    {
        public WriteData writeData;
        public WriteMain writeMain;
        string nowTime;

        public PostData(WriteMain writeMain, WriteData writeData)
        {
            this.writeMain = writeMain;
            this.writeData = writeData;
        }


        public string MakePostData(string name, string mail, string body, string server_time, string buttonText)
        {

            if (Util.BoardUrlToBoardTypeName(this.writeData.threadDatAddress).StartsWith("jbbs") == true)
            {
                this.writeData.postData = Util.BuildJbbsPostStr(
                    name, mail, body, this.writeData.boardID, this.writeData.threadID, server_time);
            }
            else if (Util.BoardUrlToBoardTypeName(this.writeData.threadDatAddress).StartsWith("machi") == true)
            {
                this.writeData.postData = MakePostDataMACHIBBS(
                    this.writeData.nameText, this.writeData.mailText, this.writeData.contentsText,
                    nowTime, this.writeData.buttonText);
            }
            else
            {
                this.writeData.postData = Util.BuildPostStr(
                    name, mail, body, this.writeData.boardID, this.writeData.threadID, server_time, Const.session_id, buttonText);

                if (Util.BoardType(this.writeData.boardUrl) == Util.TYPE_2CH)
                {
                    //浪人が有効ならば
                    if (Const.RoninState == true)
                        this.writeData.postData += "&sid=" + Const.RoninSessionID;
                }
            }
            return this.writeData.postData;
        }
        public string MakePostDataMACHIBBS(string name, string mail, string body, string server_time, string buttonText)
        {
                this.writeData.postData = Util.BuildMACHIBBSPostStr(
                    name, mail, body, this.writeData.boardID, this.writeData.threadID, server_time, Const.session_id, buttonText);

            return this.writeData.postData;
        }
        public string PostTo2ch(string postData)
        {

            SendPostData sendPostData = new SendPostData();
            if (true == sendPostData.Send(this.writeData.threadUrl, this.writeData.writeAddress, postData))
            {
                return sendPostData.httpResData;
            }
            else
            {
            }
            return "";
        }

        public void Start()
        {
            if (this.writeData.contentsText.Length == 0) return;

            Thread t = new Thread(new ThreadStart(PostDataTask));
            t.IsBackground = true;
            t.Start();
        }
        public static string AddHiddenValue(string postData, string boardUrl)
        {
            switch (Util.BoardType(boardUrl))
            {
                case Util.TYPE_2CH:
                    {
                        int length = Const._2chHiddenName.Count;
                        for (int x = 0; x < length; x += 1)
                        {
                            postData += "&" + Const._2chHiddenName[x] + "=" + Const._2chHiddenValue[x];
                        }
                        break;
                    }
                case Util.TYPE_MACHIBBS:
                    {
                        int length = Const.machiHiddenName.Count;
                        for (int x = 0; x < length; x += 1)
                        {
                            postData += "&" + Const.machiHiddenName[x] + "=" + Const.machiHiddenValue[x];
                        }
                        break;
                    }
                case Util.TYPE_2CHSC:
                    {
                        int length = Const._2chscHiddenName.Count;
                        for (int x = 0; x < length; x += 1)
                        {
                            postData += "&" + Const._2chscHiddenName[x] + "=" + Const._2chscHiddenValue[x];
                        }
                        break;
                    }
                case Util.TYPE_OPEN2CH:
                    {
                        int length = Const.open2chHiddenName.Count;
                        for (int x = 0; x < length; x += 1)
                        {
                            postData += "&" + Const.open2chHiddenName[x] + "=" + Const.open2chHiddenValue[x];
                        }
                        break;
                    }
                case Util.TYPE_NEXT2CH:
                    {
                        int length = Const.next2chHiddenName.Count;
                        for (int x = 0; x < length; x += 1)
                        {
                            postData += "&" + Const.next2chHiddenName[x] + "=" + Const.next2chHiddenValue[x];
                        }
                        break;
                    }
                case Util.TYPE_JIKKYO:
                    {
                        int length = Const.jikkyoHiddenName.Count;
                        for (int x = 0; x < length; x += 1)
                        {
                            postData += "&" + Const.jikkyoHiddenName[x] + "=" + Const.jikkyoHiddenValue[x];
                        }
                        break;
                    }
                case Util.TYPE_BLOGBAN:
                    {
                        int length = Const.blogbanHiddenName.Count;
                        for (int x = 0; x < length; x += 1)
                        {
                            postData += "&" + Const.blogbanHiddenName[x] + "=" + Const.blogbanHiddenValue[x];
                        }
                        break;
                    }
                case Util.TYPE_SHIZU:
                    {
                        int length = Const.shizuHiddenName.Count;
                        for (int x = 0; x < length; x += 1)
                        {
                            postData += "&" + Const.shizuHiddenName[x] + "=" + Const.shizuHiddenValue[x];
                        }
                        break;
                    }
                case Util.TYPE_VIP2CH:
                    {
                        int length = Const.vip2chHiddenName.Count;
                        for (int x = 0; x < length; x += 1)
                        {
                            postData += "&" + Const.vip2chHiddenName[x] + "=" + Const.vip2chHiddenValue[x];
                        }
                        break;
                    }
                case Util.TYPE_UNKNOWN:
                    {
                        int length = Const._2chHiddenName.Count;
                        for (int x = 0; x < length; x += 1)
                        {
                            postData += "&" + Const._2chHiddenName[x] + "=" + Const._2chHiddenValue[x];
                        }
                        break;
                    }
                case Util.TYPE_JBBS:
                    {
                        int length = Const.jbbsHiddenName.Count;
                        for (int x = 0; x < length; x += 1)
                        {
                            postData += "&" + Const.jbbsHiddenName[x] + "=" + Const.jbbsHiddenValue[x];
                        }
                        break;
                    }
            }
            return postData;
        }
        public static void SetHiddenValue(string hiddenName, string hiddenValue, string boardUrl)
        {
            switch (Util.BoardType(boardUrl))
            {
                case Util.TYPE_2CH:
                    Const._2chHiddenName.Add(hiddenName);
                    Const._2chHiddenValue.Add(hiddenValue);
                    return;
                case Util.TYPE_MACHIBBS:
                    Const.machiHiddenName.Add(hiddenName);
                    Const.machiHiddenValue.Add(hiddenValue);
                    return;
                case Util.TYPE_2CHSC:
                    Const._2chscHiddenName.Add(hiddenName);
                    Const._2chscHiddenValue.Add(hiddenValue);
                    return;
                case Util.TYPE_OPEN2CH:
                    Const.open2chHiddenName.Add(hiddenName);
                    Const.open2chHiddenValue.Add(hiddenValue);
                    return;
                case Util.TYPE_NEXT2CH:
                    Const.next2chHiddenName.Add(hiddenName);
                    Const.next2chHiddenValue.Add(hiddenValue);
                    return;
                case Util.TYPE_JIKKYO:
                    Const.jikkyoHiddenName.Add(hiddenName);
                    Const.jikkyoHiddenValue.Add(hiddenValue);
                    return;
                case Util.TYPE_BLOGBAN:
                    Const.blogbanHiddenName.Add(hiddenName);
                    Const.blogbanHiddenValue.Add(hiddenValue);
                    return;
                case Util.TYPE_SHIZU:
                    Const.shizuHiddenName.Add(hiddenName);
                    Const.shizuHiddenValue.Add(hiddenValue);
                    return;
                case Util.TYPE_VIP2CH:
                    Const.vip2chHiddenName.Add(hiddenName);
                    Const.vip2chHiddenValue.Add(hiddenValue);
                    return;
                case Util.TYPE_UNKNOWN:
                    Const._2chHiddenName.Add(hiddenName);
                    Const._2chHiddenValue.Add(hiddenValue);
                    return;
                case Util.TYPE_JBBS:
                    Const.jbbsHiddenName.Add(hiddenName);
                    Const.jbbsHiddenValue.Add(hiddenValue);
                    return;
            }
            return;
        }
        private void PostDataTask()
        {
            try
            {
                //this.writeData = writeData;

                //if (this.writeData.contentsText.Length == 0) return;
                this.nowTime = (UnixTime.GetNowUnixTime(DateTime.UtcNow) - 10000).ToString().Split('.')[0];


                this.writeData.postData = MakePostData(
                    this.writeData.nameText, this.writeData.mailText, this.writeData.contentsText,
                    nowTime, this.writeData.buttonText);


                this.writeData.postData = AddHiddenValue(this.writeData.postData, this.writeData.boardUrl);
                //以前のhiddenvalue追加のコード
                /*if ((Const.hiddenValue.Length != 0) && (Const.hiddenName.Length != 0))
                {
                    if (Const.hiddenName.Equals("sid") == false)
                        this.writeData.postData += "&" + Const.hiddenName + "=" + Const.hiddenValue;
                }*/

                string resData = PostTo2ch(this.writeData.postData);

                //しずちゃん用。
                if (this.writeData.boardUrl.Contains("shizu.0000.jp") == true)
                {
                    Const.form.mainForm.Invoke((Action)(() => this.writeData.htmlData = "<html><body>書き込みました<body></html>"));

                    this.writeMain.MODE = "BROWSER";
                    WriteToBrowser();
                    //ログに出力
                    this.SaveLog();
                    this.writeMain.ChangePanel("書き込みました");
                    return;
                }

                if ((resData == null) || (resData.Length == 0)) return;



                this.writeMain.writeBrowserPanel.innerBrowserParts.BrowserClear();

                string title = "";
                string text = "";

                Const.form.mainForm.Invoke((Action)(() => this.writeMain.writeBrowserPanel.innerBrowserParts.Write(resData)));
                //this.writeMain.writeBrowserPanel.innerBrowserParts.Write(resData);
                Const.form.mainForm.Invoke((Action)(() => this.writeMain.writeBrowserPanel.innerBrowserParts.AllowNavigation = false));

                Const.form.mainForm.Invoke((Action)(() => title = this.writeMain.writeBrowserPanel.innerBrowserParts.control.Document.Title));
                Const.form.mainForm.Invoke((Action)(() => text = this.writeMain.writeBrowserPanel.innerBrowserParts.control.Document.Body.InnerText));

                //フォームのアクションを書き換える


                if (true == title.Contains("書きこみました"))
                {
                    Const.form.mainForm.Invoke((Action)(() => this.writeData.htmlData = "<html><body>書き込みました<body></html>"));

                    this.writeMain.MODE = "BROWSER";
                    WriteToBrowser();
                    //ログに出力
                    this.SaveLog();
                    this.writeMain.ChangePanel("書き込みました");
                }

                else if ((true == title.Contains("ＥＲＲＯＲ")) || (true == title.Contains("お茶でも")))
                {
                    Const.form.mainForm.Invoke((Action)(() => this.writeData.htmlData = this.writeMain.writeBrowserPanel.innerBrowserParts.control.Document.Body.OuterHtml));//"<html><body>書き込みました<body></html>";

                    this.writeMain.MODE = "BROWSER";
                    WriteToBrowser();
                    this.writeMain.ChangePanel("");
                }

                else if (true == title.Contains("書き込み確認"))
                {
                    HtmlElementCollection htmlElementCollection = null;

                    Const.form.mainForm.Invoke((Action)(() => htmlElementCollection = this.writeMain.writeBrowserPanel.innerBrowserParts.control.Document.Forms));

                    HtmlElementCollection htmlElementCollection2 = htmlElementCollection[0].Children;

                    foreach (HtmlElement htmlElement in htmlElementCollection2)
                    {
                        mshtml.IHTMLElement inputTag = (mshtml.IHTMLElement)htmlElement.DomElement;

                        mshtml.IHTMLInputElement iihl = inputTag as mshtml.IHTMLInputElement;
                        if (iihl == null) continue;

                        if ((false == iihl.name.Equals("subject")) &&
                            (false == iihl.name.Equals("FROM")) &&
                            (false == iihl.name.Equals("mail")) &&
                            (false == iihl.name.Equals("MESSAGE")) &&
                            (false == iihl.name.Equals("bbs")) &&
                            (false == iihl.name.Equals("time")) &&
                            (false == iihl.name.Equals("key")) &&
                            (true == iihl.type.Equals("hidden")))
                        {
                            string hiddenName = iihl.name;
                            string hiddenValue = iihl.value;

                            if (hiddenName == null) hiddenName = "test";
                            if (hiddenValue == null) hiddenValue = "test";

                            SetHiddenValue(hiddenName, hiddenValue, this.writeData.boardUrl);

                            if (Util.BoardType(writeData.boardUrl) == Util.TYPE_NEXT2CH)
                                this.writeData.buttonText = "規約に同意して書き込む";
                            else
                                this.writeData.buttonText = "上記全てを承諾して書き込む";
                        }
                    }

                    string actionAddr = ((mshtml.HTMLFormElement)(htmlElementCollection[0].DomElement)).action;
                    Const.form.mainForm.Invoke((Action)(() => ((mshtml.HTMLFormElement)(htmlElementCollection[0].DomElement)).action = "javascript:void(0);#kakunin" + "#" + actionAddr));
                    Const.form.mainForm.Invoke((Action)(() => this.writeData.htmlData = this.writeMain.writeBrowserPanel.innerBrowserParts.control.Document.Body.OuterHtml));

                    this.writeMain.MODE = "BROWSER";
                    WriteToBrowser();
                    this.writeMain.ChangePanel("");
                }
                else
                {
                    Const.form.mainForm.Invoke((Action)(() => this.writeData.htmlData = this.writeMain.writeBrowserPanel.innerBrowserParts.control.Document.Body.OuterHtml));//"<html><body>書き込みました<body></html>";

                    this.writeMain.MODE = "BROWSER";
                    WriteToBrowser();
                    this.writeMain.ChangePanel("");
                }
            }
            catch { ;}
        }

        public void WriteToBrowser()
        {
            Const.form.mainForm.Invoke((Action)(() => this.writeMain.writeBrowserPanel.innerBrowserParts.BrowserClear()));
            Const.form.mainForm.Invoke((Action)(() => this.writeMain.writeBrowserPanel.myWebBrowserParts.BrowserClear()));

            Const.form.mainForm.Invoke((Action)(() => this.writeMain.writeBrowserPanel.myWebBrowserParts.Write(this.writeData.htmlData)));
            Const.form.mainForm.Invoke((Action)(() => this.writeMain.writeBrowserPanel.myWebBrowserParts.AllowNavigation = false));
        }

        public void SaveLog()
        {
            //ファイル名を板名とタイトル名と時間によって作る
            string fileName = BoardDataBase.GetName(
                this.writeData.boardUrl) + "." + this.writeData.titleName + "." + this.nowTime + ".txt";

            //名前：メール：内容のフォーマットでセーブする
            string str = "名前:" + this.writeData.nameText + "\r\n" +
                "メールアドレス:" + this.writeData.mailText + "\r\n" +
                "内容:\r\n" + this.writeData.contentsText + "\r\n";

            FileIO.SaveShiftJis(".ageon" + Path.DirectorySeparatorChar + "WriteToThread", fileName, str);
        }
    }
}
