﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;

namespace nispi.WriteToThread
{
    class WriteFormPanel
    {
                //パネルを一つ
        public PanelParts writeFormPanelParts;

        //ラベル２つほど
        public LabelParts threadNameLabelParts;
        public LabelParts boardNameLabelParts;
        public LabelParts threadNameLabel2Parts;
        public LabelParts boardNameLabel2Parts;

        public LabelParts nameLabelParts;
        public LabelParts mailLabelParts;

        //テキストボックス４つほど
        public TextBoxParts nameTextBoxParts;
        public TextBoxParts mailTextBoxParts;
        //public TextBox sendTextbox;
        public TextBoxParts contentsTextBoxParts;

        //ボタン2つほど
        public ButtonParts postButtonParts;
        public ButtonParts resetButtonParts;

        //移動ボタン
        //public ButtonParts returnFormButtonParts;

        public WriteData writeData;

        public WriteMain writeMain;

        public WriteFormPanel(WriteMain writeMain,string datUrl, string titleName)
        {
            writeData = new WriteData(datUrl, titleName);

            //ラベル２つほど
            this.threadNameLabelParts = LabelPartsManager.Pop();
            this.boardNameLabelParts = LabelPartsManager.Pop();
            this.threadNameLabel2Parts = LabelPartsManager.Pop();
            this.boardNameLabel2Parts = LabelPartsManager.Pop();

            this.nameLabelParts = LabelPartsManager.Pop();
            this.mailLabelParts = LabelPartsManager.Pop();

            this.nameTextBoxParts = TextBoxPartsManager.Pop();
            this.mailTextBoxParts = TextBoxPartsManager.Pop();
            //public TextBox sendTextbox;
            this.contentsTextBoxParts = TextBoxPartsManager.Pop();

            //ボタン2つほど
            this.postButtonParts = ButtonPartsManager.Pop();
            this.resetButtonParts = ButtonPartsManager.Pop();

            //書き込みフォームのパネル
            this.writeFormPanelParts = PanelPartsManager.Pop();
            this.writeFormPanelParts.Size = new Size(writeMain.writeMainForm.Size.Width - 2, writeMain.writeMainForm.Size.Height - 2);
            this.writeFormPanelParts.Location = new Point(1, 1);
            

            this.boardNameLabelParts.Location = new Point(4, 2);
            this.boardNameLabelParts.Name = "boardNameLabelk";
            this.boardNameLabelParts.Size = new Size(100, 30);
            this.boardNameLabelParts.Text = "板名：";

            this.threadNameLabelParts.Location = new Point(4, 34);
            this.threadNameLabelParts.Name = "threadNameLabelk";
            this.threadNameLabelParts.Size = new Size(100, 30);
            this.threadNameLabelParts.Text = "タイトル：";

            this.nameLabelParts.Location = new Point(4, 66);
            this.nameLabelParts.Name = "nameLabelk";
            this.nameLabelParts.Size = new Size(100, 30);
            this.nameLabelParts.Text = "名前：";

            this.mailLabelParts.Location = new System.Drawing.Point(4, 98);
            this.mailLabelParts.Name = "mailLabelk";
            this.mailLabelParts.Size = new Size(120, 30);
            this.mailLabelParts.Text = "メール：";

            this.boardNameLabel2Parts.Location = new Point(104, 2);
            this.boardNameLabel2Parts.Name = "boardNameLabel2k";
            this.boardNameLabel2Parts.Size = new Size(200, 30);
            this.boardNameLabel2Parts.Text = BoardDataBase.GetName(Util.DatUrlToBoardUrl(datUrl));

            this.threadNameLabel2Parts.Location = new Point(104, 34);
            this.threadNameLabel2Parts.Name = "threadNameLabel2k";
            this.threadNameLabel2Parts.Size = new Size(writeMain.writeMainForm.Size.Width - 134, 30);
            this.threadNameLabel2Parts.Text = titleName;
            this.threadNameLabel2Parts.SetToolTip(titleName);

            this.nameTextBoxParts.Location = new Point(104, 66);
            this.nameTextBoxParts.Name = "nameTextBoxk";
            this.nameTextBoxParts.Size = new Size(144, 30);
            this.nameTextBoxParts.TextChanged += new EventHandler(nameTextBoxParts_TextChanged);
            this.nameTextBoxParts.Text = Const.opt.writeOption.WriteName;

            this.mailTextBoxParts.Location = new Point(104, 98);
            this.mailTextBoxParts.Name = "mailTextBox";
            this.mailTextBoxParts.Size = new Size(144, 30);
            this.mailTextBoxParts.TextChanged += new EventHandler(mailTextBoxParts_TextChanged);
            this.mailTextBoxParts.Text = Const.opt.writeOption.WriteMail;
            
            this.contentsTextBoxParts.Location = new Point(4, 128);
            this.contentsTextBoxParts.Multiline = true;
            this.contentsTextBoxParts.Name = "contentsTextBoxk";
            this.contentsTextBoxParts.Size = new Size(writeMain.writeMainForm.Size.Width - 24, 290);
            this.contentsTextBoxParts.TextChanged += new EventHandler(contentsTextBoxParts_TextChanged);

            this.resetButtonParts.Text = "リセット";
            this.resetButtonParts.Location = new Point(4, 420);
            this.resetButtonParts.Name = "resetButtonk";
            this.resetButtonParts.Size = new Size(80, 30);
                        
            this.postButtonParts.Text = "書き込む";
            this.postButtonParts.Location = new Point(100, 420);
            this.postButtonParts.Name = "postButtonk";
            this.postButtonParts.Size = new Size(80, 30);

            this.writeFormPanelParts.AddControl(this.resetButtonParts);
            this.writeFormPanelParts.AddControl(this.postButtonParts);
            //writeFormPanelParts.AddControl(this.dummyLabel);
            this.writeFormPanelParts.AddControl(this.contentsTextBoxParts);
            this.writeFormPanelParts.AddControl(this.mailTextBoxParts);
            this.writeFormPanelParts.AddControl(this.nameTextBoxParts);
            this.writeFormPanelParts.AddControl(this.threadNameLabel2Parts);
            this.writeFormPanelParts.AddControl(this.boardNameLabel2Parts);
            this.writeFormPanelParts.AddControl(this.mailLabelParts);
            this.writeFormPanelParts.AddControl(this.nameLabelParts);
            this.writeFormPanelParts.AddControl(this.threadNameLabelParts);
            this.writeFormPanelParts.AddControl(this.boardNameLabelParts);
        }

        private void nameTextBoxParts_TextChanged(object sender, EventArgs e)
        {
            this.writeData.nameText = this.nameTextBoxParts.Text;
        }
        private void mailTextBoxParts_TextChanged(object sender, EventArgs e)
        {
            this.writeData.mailText = this.mailTextBoxParts.Text;
        }
        private void contentsTextBoxParts_TextChanged(object sender, EventArgs e)
        {
            this.writeData.contentsText = this.contentsTextBoxParts.Text;
        }

        public WriteData GetWriteData()
        {
            return writeData;
        }
    }
}
