﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Runtime.InteropServices;
using System.Drawing;

namespace nispi
{
    class CalendarInMapControlView
    {
        private static CalendarCommon calendarCommon = null;
        public static int containKakoLog;
        public static MapControlView mapControlView;

        public CalendarInMapControlView(int _containKakoLog, Point point, MapControlView _mapControlView)
        {
            if (calendarCommon == null)
                calendarCommon = new CalendarCommon(calendar_DateSelected, calendar_LostFocus);

            containKakoLog = _containKakoLog;
            mapControlView = _mapControlView;
            
            calendarCommon.CalendarShow(point);
        }

        public void calendar_DateSelected(object sender, DateRangeEventArgs e)
        {

            Const.form.mainForm.SetWaitCursor();

            DateTime dt = e.Start.Date;

            string month = dt.Month.ToString();
            if (month.Length == 1) month = "0" + month;
            string day = dt.Day.ToString();
            if (day.Length == 1) day = "0" + day;

            string fileName = dt.Year.ToString() + "_" + month + "_" + day;


            //地図の表示を書き換え
            GetScreeningImage getScreeningImage = 
                new GetScreeningImage(mapControlView.frontFile, fileName, mapControlView.nameDic, mapControlView.colorDic);
            BitmapSets bitmapSets = getScreeningImage.GetSurviveThreadImage(0,null,fileName);

            if (bitmapSets != null)
            {
                mapControlView.fillBitmap.Dispose();
                mapControlView.pointBitmap.Dispose();
                mapControlView.fillBitmap = bitmapSets.fillBitmap;
                mapControlView.pointBitmap = bitmapSets.pointBitmap;

                mapControlView.synthesisBitmap = ImageUtil.SynthesisImage(mapControlView.fillBitmap, mapControlView.pointBitmap);
                mapControlView.picBoxParts.Image.Dispose();
                mapControlView.picBoxParts.Image = mapControlView.synthesisBitmap;
            }

            //ツリービューのノードの書き換え
            GetScreeningIndex getScreeningIndex = new GetScreeningIndex(
                mapControlView.frontFile, fileName, mapControlView.nameDic, mapControlView.colorDic);
            getScreeningIndex.GetSurviveThreadIndex(0, null, fileName);

            Const.form.mainForm.ReSetWaitCursor();

            calendarCommon.popUp.Hide();
            calendarCommon.calendar.Hide();
            mapControlView.pinPointJPDate = 
                /*mapControlView.pinPointDateButtonParts.Text = */dt.Year.ToString().Substring(2, 2) + "年" + dt.Month.ToString() + "月" + dt.Day.ToString() + "日";
        }

        public void calendar_LostFocus(object sender, EventArgs e)
        {
            calendarCommon.popUp.Hide();
            calendarCommon.calendar.Hide();
        }
    }
}