﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Threading;
using MecInfoDll;
using System.Runtime.InteropServices;
using System.Linq;

using nispi.controlclass;

namespace nispi
{
    class MouseGesture
    {
        public static Form popUp;
        //public PictureBox picBox;
        public delegate void SimpleMethod();
        //public Bitmap bitmap;
        private int speed = 0;
        private ListView listView = null;
        public static Mutex mutex = new Mutex();

        //フォームの縦の大きさ
        int formHeight = 0;
        int halfFormHeight = 0;
        int partsHeight = 15;
        int notch = 0;

        public static Thread t2;
        //static int FirstNum = 0;
        static bool CloseFlag = false;
        public static string ON_OFF = "OFF";
        public MouseGesture()
        {
            ON_OFF = "ON";

            //フォーム
            popUp = new Form();
            popUp.Hide();
            popUp.StartPosition = FormStartPosition.Manual;
            popUp.FormBorderStyle = FormBorderStyle.None;
            popUp.MouseMove += new MouseEventHandler(popUp_MouseMove);
            popUp.MouseLeave += new EventHandler(popUp_MouseLeave);
            popUp.LostFocus += new EventHandler(popUp_LostFocus);
            popUp.Click += new EventHandler(popUp_Click);
            popUp.Opacity = 0.3;
            popUp.ShowInTaskbar = false;
            popUp.ShowIcon = false;

            popUp.BackgroundImage = Resources.mousegesture;
            popUp.TransparencyKey = Color.White;
            popUp.BackgroundImageLayout = ImageLayout.Center;


            mutex.WaitOne();
            CloseFlag = false;
            mutex.ReleaseMutex();

            popUp.Location = MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].
                boardListControls.tabPageExParts.control.PointToScreen(
                MainFormConst.boardListTabMain.
                favoriteBoardView.boardListControls.listViewParts.Location);

            popUp.Size = new Size(MainFormConst.boardListTabMain.favoriteBoardView.boardListControls.listViewParts.Size.Width,
                MainFormConst.boardListTabMain.favoriteBoardView.boardListControls.listViewParts.Size.Height);

            //ジェスチャー用のデータを作成
            formHeight = popUp.Size.Height;
            halfFormHeight = formHeight / 2;
            notch = halfFormHeight / partsHeight;


            /*
             * Bitmap bmp = new Bitmap(Resources.mousegesture);
            //透明にする色
            Color transColor = bmp.GetPixel(0, 0);
            //画像を透明にする
            bmp.MakeTransparent(transColor);
            //背景画像を指定する
            popUp.BackgroundImage = bmp;
            //背景色を指定する
            popUp.BackColor = transColor;
            //透明を指定する
            popUp.TransparencyKey = transColor;
             */

            //picBox = new PictureBox();
            //picBox.Image = Resources.mousegesture;
            //picBox.Location = new Point(popUp.Size.Width / 2 - 22, popUp.Size.Height / 2 - 22);

            //picBox.BackColor = Color.Transparent;
            //popUp.Controls.Add(picBox);




        }

        public void SetUpTwo()
        {

                t2 = new Thread(new ThreadStart(ScrollListViewThread));
                t2.IsBackground = true;
                t2.Start();

                Const.form.mainForm.Name = "isPopUp";
                try
                {

                    popUp.ShowDialog();
                }
                catch { ;}
            }


        private void popUp_MouseMove(object sender, MouseEventArgs e)
        {
            int y = 0;
            mutex.WaitOne();
            //下半分のとき
            if (e.Y > halfFormHeight)
            {
                y = e.Y - halfFormHeight;

                speed = (int)(y / notch);

                popUp.Text = speed.ToString();
            }
            //上半分の時
            else
            {
                y = halfFormHeight - e.Y;

                //mutex.WaitOne();

                speed = -(int)(y / notch);

                popUp.Text = speed.ToString();
            }
            mutex.ReleaseMutex();
        }

        public void ScrollListViewThread()
        {
            int index = 0;
            int maxIndex = 0;

            Const.form.mainForm.Invoke((Action)(() =>
                this.listView = MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].
                boardListControls.listViewParts.control));

            Const.form.mainForm.Invoke((Action)(() =>
                index = MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].
                boardListControls.listViewParts.control.TopItem.Index));

            Const.form.mainForm.Invoke((Action)(() =>
                maxIndex = MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].
                boardListControls.listViewParts.control.Items.Count));

            int speed = 0;
            int waitTime = 0;
            while (true)
            {
                mutex.WaitOne();
                if (CloseFlag == true)
                {
                    mutex.ReleaseMutex();
                    break;
                }

                speed = this.speed;

                mutex.ReleaseMutex();

                switch (speed)
                {
                    case -1:
                    case -2:
                    case -3:
                    case 1:
                    case 2:
                    case 3:
                        Thread.Sleep(100);
                        continue;
                    case -4:
                    case 4:
                        waitTime = 500;
                        break;
                    case -5:
                    case 5:
                        waitTime = 250;
                        break;
                    case -6:
                    case 6:
                        waitTime = 125;
                        break;
                    case -7:
                    case 7:
                        waitTime = 60;
                        break;
                    case -8:
                    case 8:
                        waitTime = 30;
                        break;
                    case -9:
                    case 9:
                        waitTime = 15;
                        break;
                    case -10:
                    case 10:
                        waitTime = 7;
                        break;
                    case -11:
                    case 11:
                        waitTime = 3;
                        break;
                    case -12:
                    case 12:
                        waitTime = 2;
                        break;
                    case -13:
                    case 13:
                        waitTime = 1;
                        break;
                    case -14:
                    case 14:
                        waitTime = 1;
                        break;
                    case -15:
                    case 15:
                        waitTime = 0;
                        break;
                    default:
                        waitTime = 0;
                        break;
                }

                if (speed > 0)
                {
                    index += 1;
                }
                else if (speed < 0)
                {
                    index -= 1;
                }

                if (index >= 0)
                    Const.form.mainForm.Invoke(new Scroll_Delegate(Scroll), index);

                if (index < 0)
                    index = 0;
                if (index >= maxIndex)
                    index = maxIndex;

                Thread.Sleep(waitTime);
            }
        }
        delegate void Scroll_Delegate(int index);
        public void Scroll(int index)
        {
            try
            {
                this.listView.TopItem =
                    MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].
                    boardListControls.listViewParts.control.Items[index];
            }
            catch { ;}
        }
        private void popUp_MouseLeave(object sender, EventArgs e)
        {
            this.Closing();
        }
        private void popUp_Click(object sender, EventArgs e)
        {
            this.Closing();
        }
        private void popUp_LostFocus(object sender, EventArgs e)
        {
            this.Closing();
        }
        //ウィンドウを隠す
        public void Closing()
        {
            try
            {
                Const.form.mainForm.Name = "Form";
                if (popUp.Visible == true)
                {
                    mutex.WaitOne();
                    CloseFlag = true;
                    mutex.ReleaseMutex();

                    t2.Join();

                    popUp.MouseMove -= new MouseEventHandler(popUp_MouseMove);
                    popUp.MouseLeave -= new EventHandler(popUp_MouseLeave);
                    popUp.LostFocus -= new EventHandler(popUp_LostFocus);
                    popUp.Click -= new EventHandler(popUp_Click);
                    popUp.Hide();
                    
                    popUp.Dispose();

                    ON_OFF = "OFF";
                    
                }

            }
            catch { ;}
        }
    }
}
