﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Threading;
using MecInfoDll;
using System.Runtime.InteropServices;
using System.Linq;


namespace nispi
{
    class MouseGesture2
    {
        public static Form popUp;
        public static PictureBox picBox;
        public delegate void SimpleMethod();
        public SimpleMethod closeDele;
        private int speed = 0;
        private ListView listView = null;
        public static Mutex mutex = new Mutex(false, "MouseGesture");

        //フォームの縦の大きさ
        int formHeight = 0;
        int halfFormHeight = 0;
        int partsHeight = 15;
        int notch = 0;

        Thread t2;

        public MouseGesture2()
        {
            if (popUp == null)
            {
                //フォーム
                popUp = new Form();
                popUp.Hide();
                popUp.StartPosition = FormStartPosition.Manual;
                //popUp.FormBorderStyle = FormBorderStyle.None;

                popUp.MouseMove += new MouseEventHandler(popUp_MouseMove);
                popUp.Opacity = 0.5;

                popUp.MouseLeave += new EventHandler(popUp_MouseLeave);
                picBox = new PictureBox();
                picBox.Image = Resources.mousegesture;

                picBox.BackColor = Color.Transparent;
                popUp.Controls.Add(picBox);
            }

        }

        public void SetUpTwo()
        {
            Const.form.mainForm.Invoke((Action)(() =>
                this.listView = MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].
                boardListControls.listViewParts.control));

            Const.form.mainForm.Invoke((Action)(() =>
                popUp.Size = new Size(MainFormConst.boardListTabMain.favoriteBoardView.boardListControls.listViewParts.Size.Width,
                MainFormConst.boardListTabMain.favoriteBoardView.boardListControls.listViewParts.Size.Height)));

            Const.form.mainForm.Invoke((Action)(() =>
                popUp.Location = MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].
                boardListControls.tabPageExParts.control.PointToScreen(
                MainFormConst.boardListTabMain.
                favoriteBoardView.boardListControls.listViewParts.Location)));

            Const.form.mainForm.Invoke((Action)(() =>
                picBox.Location = new Point(popUp.Size.Width / 2 - 22, popUp.Size.Height / 2 - 22)));

            //ジェスチャー用のデータを作成
            formHeight = popUp.Size.Height;
            halfFormHeight = formHeight / 2;
            notch = halfFormHeight / partsHeight;

            popUp.ShowDialog();

            t2 = new Thread(new ThreadStart(ScrollListViewThread));
            t2.IsBackground = true;
            t2.Start();
        }
        private void popUp_MouseMove(object sender, MouseEventArgs e)
        {
            int y = 0;

            //下半分のとき
            if (e.Y > halfFormHeight)
            {
                y = e.Y - halfFormHeight;

                mutex.WaitOne();

                speed = (int)(y / notch);

                popUp.Text = speed.ToString();

                mutex.ReleaseMutex();
            }
            //上半分の時
            else
            {
                y = halfFormHeight - e.Y;

                mutex.WaitOne();

                speed = -(int)(y / notch);

                popUp.Text = speed.ToString();

                mutex.ReleaseMutex();
            }
        }

        public void ScrollListViewThread()
        {
            int index = 0;

            Const.form.mainForm.Invoke((Action)(() =>
                index = MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].
                boardListControls.listViewParts.control.TopItem.Index));

            int speed = 0;
            int waitTime = 0;
            while (true)
            {
                mutex.WaitOne();

                speed = this.speed;

                mutex.ReleaseMutex();

                switch (speed)
                {
                    case -1:
                    case -2:
                    case -3:
                    case 1:
                    case 2:
                    case 3:
                        Thread.Sleep(100);
                        continue;
                    case -4:
                    case 4:
                        waitTime = 1000;
                        break;
                    case -5:
                    case 5:
                        waitTime = 500;
                        break;
                    case -6:
                    case 6:
                        waitTime = 250;
                        break;
                    case -7:
                    case 7:
                        waitTime = 125;
                        break;
                    case -8:
                    case 8:
                        waitTime = 60;
                        break;
                    case -9:
                    case 9:
                        waitTime = 30;
                        break;
                    case -10:
                    case 10:
                        waitTime = 15;
                        break;
                    case -11:
                    case 11:
                        waitTime = 7;
                        break;
                    case -12:
                    case 12:
                        waitTime = 3;
                        break;
                    case -13:
                    case 13:
                        waitTime = 2;
                        break;
                    case -14:
                    case 14:
                        waitTime = 1;
                        break;
                    case -15:
                    case 15:
                        waitTime = 0;
                        break;
                    default:
                        waitTime = 0;
                        break;
                }

                if (speed > 0)
                {
                    index += 1;
                }
                else if (speed < 0)
                {
                    index -= 1;
                }

                if (index >= 0)
                    Const.form.mainForm.Invoke(new Scroll_Delegate(Scroll), index);

                Thread.Sleep(waitTime);
            }
        }
        delegate void Scroll_Delegate(int index);
        public void Scroll(int index)
        {
            this.listView.TopItem =
                MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].
                boardListControls.listViewParts.control.Items[index];
        }

        private void popUp_MouseLeave(object sender, EventArgs e)
        {
            this.t2.Suspend();
            this.Closing();
        }
        //呼び出し側のクロース処理を行う
        private void exitButton_Click(object sender, EventArgs e)
        {

        }
        //ウィンドウを隠す
        public void Closing()
        {
            popUp.Hide();
        }
    }
}
