﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Runtime.InteropServices;
using System.Drawing;

namespace nispi.BoardListBrowser
{
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class BoardListBrowserCtrlManager
    {
        public static Stack<BoardListBrowserParts> browserCtrlStack = new Stack<BoardListBrowserParts>();
        public static Mutex mutex = new Mutex(false, "BoardListBrowserCtrlManager");

        public static BoardListBrowserParts Pop()
        {
            mutex.WaitOne();

            if (browserCtrlStack.Count == 0)
                browserCtrlStack.Push(new BoardListBrowserParts());

            BoardListBrowserParts browserCtrl = browserCtrlStack.Pop();

            mutex.ReleaseMutex();

            return browserCtrl;
        }

        public static void Push(BoardListBrowserParts browserCtrl)
        {
            mutex.WaitOne();

            browserCtrl.ownerForm = null;
            browserCtrl.textMenuOn = true;
            browserCtrl.nonTextMenuOn = true;
            browserCtrl.BrowserClear();
            browserCtrl.ResetControl();
            browserCtrl.Update();
            
            browserCtrlStack.Push(browserCtrl);

            mutex.ReleaseMutex();
        }

        public static void ReSize(Size size)
        {
            mutex.WaitOne();

            foreach (BoardListBrowserParts bp in browserCtrlStack)
            {
                bp.Size = new Size(size.Width-4, size.Height-30);
            }

            mutex.ReleaseMutex();
        }
        /*public static BrowserParts Pop()
        {
            return new BrowserParts();
        }

        public static void Push(BrowserParts browserCtrl)
        {
            Thread t2 = new Thread(new ParameterizedThreadStart(DisposeThread));
            t2.IsBackground = true;
            t2.Start((object)browserCtrl);
        }
        private static void DisposeThread(object o)
        {
            BrowserParts parts = (BrowserParts)o;
            Const.form.mainForm.Invoke((Action)(() => parts.control.Dispose()));
        }*/
        /*public static BrowserParts Pop()
        {
            mutex.WaitOne();

            if (browserCtrlStack.Count == 0)
                browserCtrlStack.Push(new BrowserParts());

            BrowserParts browserCtrl = browserCtrlStack.Pop();

            mutex.ReleaseMutex();


            return browserCtrl;
        }

        public static void Push(BrowserParts browserCtrl)
        {
            Thread t2 = new Thread(new ParameterizedThreadStart(DisposeThread));
            t2.IsBackground = true;
            t2.Start((object)browserCtrl);
        }
        public static void DisposeThread(object o)
        {
            BrowserParts parts = (BrowserParts)o;


            //Const.form.mainForm.BeginInvoke((Action)(() => parts.ownerForm = null));
            //Const.form.mainForm.BeginInvoke((Action)(() => parts.textMenuOn = true));
            //Const.form.mainForm.BeginInvoke((Action)(() => parts.nonTextMenuOn = true));
            //Const.form.mainForm.BeginInvoke((Action)(() => parts.BrowserClear()));
            //Const.form.mainForm.BeginInvoke((Action)(() => parts.ResetControl()));
            //Const.form.mainForm.BeginInvoke((Action)(() => parts.Update()));
            parts.control.Invoke((Action)(() =>parts.ownerForm = null));
            parts.control.Invoke((Action)(() => parts.textMenuOn = true));
            parts.control.Invoke((Action)(() =>parts.nonTextMenuOn = true));
            parts.control.Invoke((Action)(() => parts.BrowserClear()));
            parts.control.Invoke((Action)(() => parts.ResetControl()));
            parts.control.Invoke((Action)(() => parts.Update()));
            mutex.WaitOne();

            browserCtrlStack.Push(parts);

            mutex.ReleaseMutex();
        }*/
    }
}
