//CZXAgeOntH_LISENCEtH_QƂĂ
using System;
using System.Collections.Generic;
using System.Text;
using mshtml;
using System.Drawing;

using System.Windows.Forms;
namespace nispi
{
    class HtmlUtil
    {
        public static bool GetHrefAndTextByPoint(BrowserParts browserParts, Point point, ref string link, ref string href)
        {
            HtmlElement clickedElement = browserParts.control.Document.GetElementFromPoint(point);
            HtmlUtil.GetClickTagInfo(clickedElement, ref href, ref link);

            if ((link.Length > 0) && (href.Length > 0))
                return true;
            else
                return false;
        }

        public static void SearchInBrowser(BrowserParts browserParts, string str)
        {
            try
            {
                bool isFound = false;
                if (str.Length == 0)
                    return;
                mshtml.IHTMLDocument2 dom = (mshtml.IHTMLDocument2)browserParts.control.Document.DomDocument;
                mshtml.IHTMLTxtRange textRange = ((mshtml.IHTMLBodyElement)dom.body).createTextRange();
                textRange = dom.selection.createRange() as mshtml.IHTMLTxtRange;

                if (textRange.text != null)
                    textRange.moveStart("character", 1);

                textRange.moveEnd("textedit", 1);
                isFound = textRange.findText(str, 1, 0);

                if (isFound)
                {
                    textRange.scrollIntoView(true);//XN[
                    textRange.select();//Ĕ͈͑I
                }
                else
                {
                    MessageBox.Show("u" + str + "vŌ܂Ō܂");//Ȃ烁bZ[W
                    browserParts.control.Document.Window.ScrollTo(new Point(0, 0));
                }
            }
            catch { ;}
        }

        public static void GetClickTagInfo(HtmlElement clickedElement, ref string href, ref string text)
        {
            try
            {
                /* <a>^Oo */
                if (clickedElement.TagName == "a" || clickedElement.TagName == "A")
                {
                    href = clickedElement.GetAttribute("href");
                    text = clickedElement.InnerText;
                }
                else if (clickedElement.Parent != null)
                {
                    if (clickedElement.Parent.TagName == "a" || clickedElement.Parent.TagName == "A")
                    {
                        href = clickedElement.Parent.GetAttribute("href");
                        text = clickedElement.Parent.InnerText;
                    }
                }
            }
            catch
            {
                href = "";
                text = "";
            }
        }

        public static void GetSelectText(ref string selectText, BrowserParts browserParts)
        {
            try
            {
                /*IĂeLXg*/
                if (browserParts.control.Document != null)
                {
                    if (browserParts.control.Document.DomDocument != null)
                    {
                        IHTMLDocument2 htmlDocument = browserParts.control.Document.DomDocument as IHTMLDocument2;
                        if (htmlDocument != null)
                        {
                            IHTMLSelectionObject currentSelection = htmlDocument.selection;
                            if (currentSelection != null)
                            {
                                IHTMLTxtRange range = currentSelection.createRange() as IHTMLTxtRange;
                                if (range != null)
                                {
                                    selectText = range.text;
                                    return;
                                }
                            }
                        }
                    }
                }
                selectText = "";
            }
            catch
            {
                selectText = "";
            }
        }
        public static void GoToResNumInBrowser(BrowserParts browserParts, string resNum)
        {
            try
            {
                HtmlDocument dom = (HtmlDocument)browserParts.control.Document;

                bool res = HtmlUtil.MoveToResNum(dom, resNum);
                if (res == false)
                    HtmlDocumentGotoEnd(dom);
            }
            catch { ;}
        }
        
        public static void GoToEndInBrowser(BrowserParts browserParts)
        {
            try
            {
                HtmlDocument dom = (HtmlDocument)browserParts.control.Document;
                HtmlDocumentGotoEnd(dom);
            }
            catch { ;}
        }

        public static bool MoveToResNum(HtmlDocument document, string text)
        {
            try
            {
                text = text.Remove(0, 2);
                /* 镶 ("<div class=\'res_title\'><a name='res" + num + "'")*/
                string searchtxt = "res" + text;

                mshtml.IHTMLDocument2 dom = (mshtml.IHTMLDocument2)document.DomDocument;
                mshtml.IHTMLTxtRange textRange = ((mshtml.IHTMLBodyElement)dom.body).createTextRange();
                foreach (HtmlElement tags in document.GetElementsByTagName("A"))
                {
                    if (tags.Name.CompareTo(searchtxt) == 0)
                    {
                        mshtml.IHTMLElement tag = (mshtml.IHTMLElement)tags.DomElement;
                        textRange.moveToElementText(tag);
                        textRange.select();
                        textRange.moveEnd("textedit", 1);
                        textRange.scrollIntoView(true);
                        return true;
                    }
                }
            }
            catch
            {
                return false;
            }
            return false;
        }

        public static void HtmlDocumentGotoEnd(HtmlDocument doc)
        {
            string searchtxt = "res";
            HtmlElement tag = null;

            try
            {
                mshtml.IHTMLDocument2 dom = (mshtml.IHTMLDocument2)doc.DomDocument;
                mshtml.IHTMLTxtRange textRange = ((mshtml.IHTMLBodyElement)dom.body).createTextRange();

                foreach (HtmlElement tags in doc.GetElementsByTagName("A"))
                {
                    if ((tags.Name.IndexOf(searchtxt) == 0) && (tags.InnerText.Equals("ڽ") == false))
                    {
                        tag = tags;
                    }
                }

                mshtml.IHTMLElement itag = (mshtml.IHTMLElement)tag.DomElement;
                textRange.moveToElementText(itag);
                textRange.select();
                textRange.moveEnd("textedit", 1);
                textRange.scrollIntoView(true);

                return;
            }
            catch { ;}
            return;
        }

        //uEŨX̏ꏊ𓾂
        public static List<Point> GetResPoints(HtmlDocument document)
        {
            try
            {
                List<Point> points = new List<Point>();

                /* 镶 ("<div class=\'res_title\'><a name='res" + num + "'")*/
                string searchtxt = "res";
                int num = 1;
                mshtml.IHTMLDocument2 dom = (mshtml.IHTMLDocument2)document.DomDocument;
                mshtml.IHTMLTxtRange textRange = ((mshtml.IHTMLBodyElement)dom.body).createTextRange();
                foreach (HtmlElement tags in document.GetElementsByTagName("A"))
                {
                    if (tags.Name.Length == 0)
                        continue;

                    searchtxt = "res" + num.ToString();
                    if (tags.Name.StartsWith(searchtxt) == true)
                    {
                        mshtml.IHTMLElement tag = (mshtml.IHTMLElement)tags.DomElement;
                        points.Add(new Point(0, tag.offsetTop));
                        num += 1;
                    }
                    else
                        continue;
                }

                return points;
            }
            catch { ;}

            return null;
        }

        public static string GetUrlType(string url)
        {
            if ((url.EndsWith("jpg") == true) ||
                (url.EndsWith("jpeg") == true) ||
                (url.EndsWith("png") == true) ||
                (url.EndsWith("gif") == true) ||
                (url.EndsWith("bmp") == true))
                return "image";
            else
                return "link";
        }
    }
}