﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;


namespace nispi.controlclass
{
    class MenuStripParts : ControlBase
    {
        private MenuStrip control;

        public MenuStripParts()
        {
            control = new MenuStrip();
            this.controlBase = (System.Windows.Forms.Control)control;
        }

        public ToolStripRenderer Renderer
        {
            set
            {
                this.control.Renderer = value;
            }
            get
            {
                return this.control.Renderer;
            }
        }

        public void ItemsAdd(ToolStripMenuItemParts parts)
        {
            this.control.Items.Add(parts.control);
        }

        public void ItemsAdd(string text)
        {
            this.control.Items.Add(text);
        }
    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class MenuStripPartsManager
    {
        public static LinkedList<MenuStripParts> allFormList = new LinkedList<MenuStripParts>();
        public static Stack<MenuStripParts> tabPageStack = new Stack<MenuStripParts>();
        public static Mutex mutex = new Mutex(false, "MenuStripPartsManager");

        public static MenuStripParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
                tabPageStack.Push(new MenuStripParts());

            MenuStripParts tabPage = tabPageStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(tabPage))
            {
                ChangeOutWard(tabPage);
                allFormList.AddLast(tabPage);
            }

            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(MenuStripParts tabPage)
        {
            tabPage.ResetControlBase();

            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (MenuStripParts parts in allFormList)
            {
                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardForm.FormForeColorRed,
                    Const.opt.outWardForm.FormForeColorGreen,
                    Const.opt.outWardForm.FormForeColorBlue);
                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardForm.FormBackColorRed,
                    Const.opt.outWardForm.FormBackColorGreen,
                    Const.opt.outWardForm.FormBackColorBlue);
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard(MenuStripParts parts)
        {
            parts.ForeColor = Color.FromArgb(
                Const.opt.outWardForm.FormForeColorRed,
                Const.opt.outWardForm.FormForeColorGreen,
                Const.opt.outWardForm.FormForeColorBlue);
            parts.BackColor = Color.FromArgb(
                Const.opt.outWardForm.FormBackColorRed,
                Const.opt.outWardForm.FormBackColorGreen,
                Const.opt.outWardForm.FormBackColorBlue);

            float scaledFloat = Scale.GetScaledFloat();

            parts.SetFont(Const.form.mainForm.GetFontName(), scaledFloat);
        }
    }
}
