﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;


namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    class RadioButtonParts : ControlBase
    {
        private RadioButton control;

        public RadioButtonParts()
        {
            control = new RadioButton();
            controlBase = (System.Windows.Forms.Control)control;
        }

        public bool Checked
        {
            set
            {
                this.control.Checked = value;
            }
            get
            {
                return this.control.Checked;
            }
        }
    }

    class RadioButtonPartsManager
    {
        public static Stack<RadioButtonParts> buttonStack = new Stack<RadioButtonParts>();
        public static Mutex mutex = new Mutex(false, "RadioButtonPartsManager");

        public static RadioButtonParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new RadioButtonParts());

            RadioButtonParts buttonParts = buttonStack.Pop();

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(RadioButtonParts buttonParts)
        {
            buttonParts.ResetControlBase();

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }
    }
}