﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Runtime.InteropServices;

using nispi.controlclass;

namespace nispi
{
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class SimpleBrowserPartsManager
    {
        public static Stack<SimpleBrowserParts> browserCtrlStack = new Stack<SimpleBrowserParts>();
        public static Mutex mutex = new Mutex(false, "BrowserCtrlManager");

        public static SimpleBrowserParts Pop()
        {
            mutex.WaitOne();

            if (browserCtrlStack.Count == 0)
                browserCtrlStack.Push(new SimpleBrowserParts());

            SimpleBrowserParts browserCtrl = browserCtrlStack.Pop();

            mutex.ReleaseMutex();

            return browserCtrl;
        }

        public static void Push(SimpleBrowserParts browserCtrl)
        {
            try
            {
                browserCtrl.ResetControlBase();
            }
            catch { ;}
            mutex.WaitOne();

            browserCtrl.ownerForm = null;
            browserCtrl.textMenuOn = true;
            browserCtrl.nonTextMenuOn = true;
            browserCtrl.BrowserClear();
            browserCtrl.ResetControl();
            
            browserCtrlStack.Push(browserCtrl);

            mutex.ReleaseMutex();
        }
    }
}
