﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;


namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    class TextBoxParts:ControlBase
    {
        private TextBox control;
        //public ThreadViewCommon threadView;

        public TextBoxParts()
        {
            control = new TextBox();
            control.Font = new Font("MS UI Gothic", 10.75F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
            //control.ReadOnly = false;
            this.controlBase = (System.Windows.Forms.Control)control;
            this.control.MouseEnter += new EventHandler(controlBase_MouseEnter);
            this.control.ScrollBars = ScrollBars.Vertical;
        }
        public void controlBase_MouseEnter(object sender, EventArgs e)
        {
            this.control.Select();
        }
        public bool Multiline
        {
            set
            {
                this.control.Multiline = value;
            }
            get
            {
                return this.control.Multiline;
            }
        }
        public bool ReadOnly
        {
            set
            {
                this.control.ReadOnly = value;
            }
            get
            {
                return this.control.ReadOnly;
            }
        }
        public event EventHandler TextChanged
        {
            add
            {
                this.control.TextChanged += value;
            }
            remove
            {
                this.control.TextChanged -= value;
            }
        }
        public bool UseSystemPasswordChar
        {
            set
            {
                this.control.UseSystemPasswordChar = value;
            }
            get
            {
                return this.control.UseSystemPasswordChar;
            }
            
        }
        public int SelectionStart
        {
            set
            {
                this.control.SelectionStart = value;
            }
        }
        public void ScrollToCaret()
        {
            this.control.ScrollToCaret();
        }
        public void AppendText(string text)
        {
            this.control.AppendText(text);
        }
    }

    class TextBoxPartsManager
    {
        public static LinkedList<TextBoxParts> allFormList = new LinkedList<TextBoxParts>();
        public static Stack<TextBoxParts> buttonStack = new Stack<TextBoxParts>();
        public static Mutex mutex = new Mutex(false, "TextBoxPartsManager");

        public static TextBoxParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new TextBoxParts());

            TextBoxParts buttonParts = buttonStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(buttonParts))
            {
                ChangeOutWard(buttonParts);
                allFormList.AddLast(buttonParts);
            }

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(TextBoxParts buttonParts)
        {
            buttonParts.ResetControlBase();
            buttonParts.Multiline = false;

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (TextBoxParts parts in allFormList)
            {
                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardForm.FormForeColorRed,
                    Const.opt.outWardForm.FormForeColorGreen,
                    Const.opt.outWardForm.FormForeColorBlue);
                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardForm.FormBackColorRed,
                    Const.opt.outWardForm.FormBackColorGreen,
                    Const.opt.outWardForm.FormBackColorBlue);
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }
        public static void ChangeOutWard(TextBoxParts parts)
        {
            /*parts.ForeColor = Color.FromArgb(
                Const.opt.outWardForm.FormForeColorRed,
                Const.opt.outWardForm.FormForeColorGreen,
                Const.opt.outWardForm.FormForeColorBlue);
            parts.BackColor = Color.FromArgb(
                Const.opt.outWardForm.FormBackColorRed,
                Const.opt.outWardForm.FormBackColorGreen,
                Const.opt.outWardForm.FormBackColorBlue);*/
        }
    }
}