﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Drawing;

using nispi.controlclass;

namespace nispi.controlclass
{
    class ToolTipParts:ControlBase
    {
        private ToolTip control;

        public ToolTipParts()
        {
            control = new ToolTip();

            //ToolTipが表示されるまでの時間
            control.InitialDelay = 0;
            //ToolTipが表示されている時に、別のToolTipを表示するまでの時間
            control.ReshowDelay = 0;
            //ToolTipを表示する時間
            control.AutoPopDelay = 10000;
            //フォームがアクティブでない時でもToolTipを表示する
            control.ShowAlways = false;

            control.IsBalloon = false;
        }

        //ToolTip1.Show("こんにちは。", this, 0, 0, 3000);
        public void ShowToolTip(string text, ControlBase cb)
        {
            control.Show(text, cb.controlBase, 0, cb.Size.Height - (int)Math.Ceiling(Scale.GetMinusScaleToolTip()));
        }
        public void ShowToolTip2(string text, ControlBase cb)
        {
            Point p = cb.controlBase.PointToClient(Cursor.Position);
            control.Show(text, cb.controlBase, p.X + 20, p.Y + 20);
        }
        public void HideToolTip()
        {
            control.RemoveAll();
        }
    }


    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class ToolTipPartsManager
    {
        public static LinkedList<ToolTipParts> allFormList = new LinkedList<ToolTipParts>();
        public static Stack<ToolTipParts> tabPageStack = new Stack<ToolTipParts>();
        public static Mutex mutex = new Mutex(false, "ToolTipPartsManager");

        public static ToolTipParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
                tabPageStack.Push(new ToolTipParts());

            ToolTipParts toolTip = tabPageStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(toolTip))
            {
                allFormList.AddLast(toolTip);
            }

            mutex.ReleaseMutex();

            return toolTip;
        }

        public static void Push(ToolTipParts tabPage)
        {
            tabPage.ResetControlBase();

            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }
    }
}