﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Threading;

namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    ///

    class WithInCBoxParts:ControlBase
    {
        private ComboBox control;

        public WithInCBoxParts()
        {
            //コンボボックス
            control = new ComboBox();
            control.Size = new Size(110, 26);

            control.DropDownStyle = ComboBoxStyle.DropDownList;
            control.Items.Add("期間指定なし");
            control.Items.Add("30分以内");
            control.Items.Add("1時間以内");
            control.Items.Add("3時間以内");
            control.Items.Add("6時間以内");
            control.Items.Add("12時間以内");
            control.Items.Add("24時間以内");
            control.Items.Add("2日以内");
            control.Items.Add("3日以内");
            control.Items.Add("1週間以内");
            control.Items.Add("2週間以内");
            control.Items.Add("1か月以内");
            control.SelectedIndex = 0;

            this.controlBase = (System.Windows.Forms.Control)control;
        }
        public event EventHandler SelectedIndexChanged
        {
            add
            {
                this.control.SelectedIndexChanged += value;
            }
            remove
            {
                this.control.SelectedIndexChanged -= value;
            }
        }
        public PlusTime GetTimeStructure()
        {
            int minute = 0;
            int hour = 0;
            int day = 0;
            int month = 0;
            int year = 0;

            int num = this.control.SelectedIndex;

            if (num == 1)
                minute = 30;
            else if (num == 2)
                hour = 1;
            else if (num == 3)
                hour = 3;
            else if (num == 4)
                hour = 6;
            else if (num == 5)
                hour = 12;
            else if (num == 6)
                hour = 24;
            else if (num == 7)
                day = 2;
            else if (num == 8)
                day = 3;
            else if (num == 9)
                day = 7;
            else if (num == 10)
                day = 14;
            else if (num == 11)
                month = 1;

            return new PlusTime(year,month,day,hour,minute);
        }


        public int SelectedIndex
        {
            set
            {
                this.control.SelectedIndex = value;
            }
            get
            {
                return this.control.SelectedIndex;
            }
        }
    }

    class WithInCBoxPartsManager
    {
        public static LinkedList<WithInCBoxParts> allFormList = new LinkedList<WithInCBoxParts>();
        public static Stack<WithInCBoxParts> buttonStack = new Stack<WithInCBoxParts>();
        public static Mutex mutex = new Mutex(false, "ThreadView_WithInCBoxManager");

        public static WithInCBoxParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new WithInCBoxParts());

            WithInCBoxParts buttonParts = buttonStack.Pop();

            buttonParts.SelectedIndex = 0;
            //GUIのリストを作成する
            if (null == allFormList.Find(buttonParts))
            {
                ChangeOutWard(buttonParts);
                allFormList.AddLast(buttonParts);
            }

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(WithInCBoxParts buttonParts)
        {
            buttonParts.ResetControlBase();

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (WithInCBoxParts parts in allFormList)
            {
                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardForm.FormForeColorRed,
                    Const.opt.outWardForm.FormForeColorGreen,
                    Const.opt.outWardForm.FormForeColorBlue);
                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardForm.FormBackColorRed,
                    Const.opt.outWardForm.FormBackColorGreen,
                    Const.opt.outWardForm.FormBackColorBlue);
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }
        public static void ChangeOutWard(WithInCBoxParts parts)
        {
            parts.ForeColor = Color.FromArgb(
                Const.opt.outWardForm.FormForeColorRed,
                Const.opt.outWardForm.FormForeColorGreen,
                Const.opt.outWardForm.FormForeColorBlue);
            parts.BackColor = Color.FromArgb(
                Const.opt.outWardForm.FormBackColorRed,
                Const.opt.outWardForm.FormBackColorGreen,
                Const.opt.outWardForm.FormBackColorBlue);

            float scaledFloat = Scale.GetScaledFloat();

            parts.SetFont(Const.form.mainForm.GetFontName(), scaledFloat);
        }
    }
}