﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace nispi.OptionControl
{
    class HistoryOptionEvent
    {
        public HistoryOption historyOption;

        private bool changeFlag = false;

        public HistoryOptionEvent(HistoryOption historyOption)
        {
            this.historyOption = historyOption;
            SetEvent();
        }
        public void SetEvent()
        {
            //クリックイベント
            this.historyOption.openAllFolderButtonParts.Click += new EventHandler(openAllFolderButtonParts_Click);
            this.historyOption.delAllButtonParts.Click += new EventHandler(delAllButtonParts_Click);
            
            this.historyOption.delThreadButtonParts.Click += new EventHandler(delThreadButtonParts_Click);
            this.historyOption.delImageButtonParts.Click += new EventHandler(delImageButtonParts_Click);

            this.historyOption.delBoardButtonParts.Click +=new EventHandler(delBoardButtonParts_Click);

            this.historyOption.wirteToBoardFolderButtonParts.Click += new EventHandler(wirteToBoardFolderButtonParts_Click);
            this.historyOption.delWriteToBoardButtonParts.Click += new EventHandler(delWriteToBoardButtonParts_Click);

            this.historyOption.wirteToThreadFolderButtonParts.Click += new EventHandler(wirteToThreadFolderButtonParts_Click);
            this.historyOption.delWriteToThreadButtonParts.Click += new EventHandler(delWriteToThreadButtonParts_Click);
        }

        public void ResetEvent()
        {
            //クリックイベント
            this.historyOption.openAllFolderButtonParts.Click -= new EventHandler(openAllFolderButtonParts_Click);
            this.historyOption.delAllButtonParts.Click -= new EventHandler(delAllButtonParts_Click);

            this.historyOption.delThreadButtonParts.Click -= new EventHandler(delThreadButtonParts_Click);
            this.historyOption.delImageButtonParts.Click -= new EventHandler(delImageButtonParts_Click);

            this.historyOption.delBoardButtonParts.Click -= new EventHandler(delBoardButtonParts_Click);

            this.historyOption.wirteToBoardFolderButtonParts.Click -= new EventHandler(wirteToBoardFolderButtonParts_Click);
            this.historyOption.delWriteToBoardButtonParts.Click -= new EventHandler(delWriteToBoardButtonParts_Click);

            this.historyOption.wirteToThreadFolderButtonParts.Click -= new EventHandler(wirteToThreadFolderButtonParts_Click);
            this.historyOption.delWriteToThreadButtonParts.Click -= new EventHandler(delWriteToThreadButtonParts_Click);
        }


        //ログのルートフォルダーを開く
        private void openAllFolderButtonParts_Click(object sender, EventArgs e)
        {
            FormGUI.OpenTargetFolder(Const.DataDir);
        }
        //ログをすべて削除する
        private void delAllButtonParts_Click(object sender, EventArgs e)
        {
            try
            {
                Directory.Delete(Const.DataDir + Path.DirectorySeparatorChar + ".ageon", true);
            }
            catch { ;}
        }
        //スレッドのログをすべて削除する
        private void delThreadButtonParts_Click(object sender, EventArgs e)
        {
            try
            {
                // .log/catch/2ch/x 以下の一階層でsubject.txt subject_info.txt以外のファイルを削除する
                string[] subFolders = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "2ch", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders2 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "2chsc", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders3 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "open2ch", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders4 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "next2ch", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders5 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "jikkyo", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders6 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "blogban", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders7 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "shizu", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders8 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "vip2ch", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders9 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "machibbs", "*", SearchOption.TopDirectoryOnly);

                subFolders = subFolders.ToList().
                    Concat(subFolders2.ToList()).
                    Concat(subFolders3.ToList()).
                    Concat(subFolders4.ToList()).
                    Concat(subFolders5.ToList()).
                    Concat(subFolders6.ToList()).
                    Concat(subFolders7.ToList()).
                    Concat(subFolders8.ToList()).
                    Concat(subFolders9.ToList()).ToArray();

                if (subFolders.Length == 0)
                    return;

                foreach (string folder in subFolders)
                {
                    string[] folders = Directory.GetFiles(folder, "*", SearchOption.TopDirectoryOnly);
                    //infoファイルを取り除く
                    string[] delFileList = folders.Where(a =>
                        ((a.EndsWith("dat") == true) ||
                        (a.EndsWith("dat.info") == true) ||
                        (a.EndsWith("shiori.xml") == true))).ToArray();

                    foreach (string file in delFileList)
                    {
                        File.Delete(file);
                    }
                }
            }
            catch { ;}
        }

        private void delImageButtonParts_Click(object sender, EventArgs e)
        {
            try
            {
                // .log/catch/2ch/x 以下の一階層でsubject.txt subject_info.txt以外のファイルを削除する
                string[] subFolders = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "2ch", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders2 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "2chsc", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders3 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "open2ch", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders4 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "next2ch", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders5 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "jikkyo", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders6 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "blogban", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders7 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "shizu", "*", SearchOption.TopDirectoryOnly);


                string[] subFolders8 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "vip2ch", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders9 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "machibbs", "*", SearchOption.TopDirectoryOnly);

                subFolders = subFolders.ToList().
                    Concat(subFolders2.ToList()).
                    Concat(subFolders3.ToList()).
                    Concat(subFolders4.ToList()).
                    Concat(subFolders5.ToList()).
                    Concat(subFolders6.ToList()).
                    Concat(subFolders7.ToList()).
                    Concat(subFolders8.ToList()).
                    Concat(subFolders9.ToList()).ToArray();

                if (subFolders.Length == 0)
                    return;

                foreach (string folder in subFolders)
                {
                    string[] folders = Directory.GetDirectories(folder, "*", SearchOption.TopDirectoryOnly);

                    foreach (string temp in folders)
                    {
                        Directory.Delete(temp,true);
                    }
                }
            }
            catch { ;}
        }

        //板のログをすべて削除する
        private void delBoardButtonParts_Click(object sender, EventArgs e)
        {
            try
            {
                // .log/catch/2ch/x 以下の一階層でsubject.txt subject_info.txt以外のファイルを削除する
                string[] subFolders = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "2ch", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders2 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "2chsc", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders3 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "open2ch", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders4 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "next2ch", "*", SearchOption.TopDirectoryOnly);


                string[] subFolders5 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "jikkyo", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders6 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "blogban", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders7 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "shizu", "*", SearchOption.TopDirectoryOnly);


                string[] subFolders8 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "vip2ch", "*", SearchOption.TopDirectoryOnly);

                string[] subFolders9 = Directory.GetDirectories(Const.DataDir + Path.DirectorySeparatorChar + ".ageon" +
                    Path.DirectorySeparatorChar + "cache" + Path.DirectorySeparatorChar + "machibbs", "*", SearchOption.TopDirectoryOnly);

                subFolders = subFolders.ToList().
                    Concat(subFolders2.ToList()).
                    Concat(subFolders3.ToList()).
                    Concat(subFolders4.ToList()).
                    Concat(subFolders5.ToList()).
                    Concat(subFolders6.ToList()).
                    Concat(subFolders7.ToList()).
                    Concat(subFolders8.ToList()).
                    Concat(subFolders9.ToList()).ToArray();

                if (subFolders.Length == 0)
                    return;

                foreach (string folder in subFolders)
                {
                    string[] folders = Directory.GetFiles(folder, "*", SearchOption.TopDirectoryOnly);
                    //infoファイルを取り除く
                    string[] delFileList = folders.Where(a =>
                        (a.EndsWith(".txt") == true)).ToArray();

                    foreach (string file in delFileList)
                    {
                        File.Delete(file);
                    }
                }
            }
            catch { ;}
        }

        //書き込みのログのフォルダを開く
        private void wirteToBoardFolderButtonParts_Click(object sender, EventArgs e)
        {
            try
            {
                string writeToBoardFolder = Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar + "WriteToBoard";
                FormGUI.OpenTargetFolder2(writeToBoardFolder);
            }
            catch { ;}
        }
        //書き込みのログをすべて削除する
        private void delWriteToBoardButtonParts_Click(object sender, EventArgs e)
        {
            try
            {
                string[] delFileList = Directory.GetFiles(
                    Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar + "WriteToBoard" + Path.DirectorySeparatorChar,
                    "*", SearchOption.TopDirectoryOnly);

                foreach (string file in delFileList)
                {
                    File.Delete(file);
                }
            }
            catch { ;}
        }
        //書き込みのログのフォルダを開く
        private void wirteToThreadFolderButtonParts_Click(object sender, EventArgs e)
        {
            try
            {
                string writeToThreadFolder =
                    Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar + "WriteToThread";
                FormGUI.OpenTargetFolder2(writeToThreadFolder);
            }
            catch { ;}
        }
        //書き込みのログをすべて削除する
        private void delWriteToThreadButtonParts_Click(object sender, EventArgs e)
        {
            try
            {
                string[] delFileList = Directory.GetFiles(
                    Const.DataDir + Path.DirectorySeparatorChar + ".ageon" + Path.DirectorySeparatorChar + "WriteToThread" + Path.DirectorySeparatorChar,
                    "*", SearchOption.TopDirectoryOnly);

                foreach (string file in delFileList)
                {
                    File.Delete(file);
                }
            }
            catch { ;}
        }

        private void ChangeFlag(object sender, EventArgs e)
        {
            this.changeFlag = true;
        }


        public void SetAllOption()
        {
            if (changeFlag == true)
            {
                changeFlag = false;

                /*this.historyOption.IsWriteHistory = this.historyOption.saveWriteCBoxParts.Checked.ToString();
                this.historyOption.HistoryFolder = this.historyOption.logOpenTBoxParts.Text;
                this.historyOption.SaveToFile();*/
            }
            else
            {
                ;
            }
        }
    }
}
