﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using nispi.controlclass;
using nispi.OptionControl.OutWard.List;

namespace nispi.OptionControl
{
    class OutWardOptionEventListView
    {
        private OutWardList outWardOption;
        public bool changeFlag = false;

        private OriginalFont originalFont = null;

        public OutWardOptionEventListView(OutWardList outWardOption)
        {
            this.outWardOption = outWardOption;
            SetEvent();
        }
        public void SetEvent()
        {
            this.outWardOption.lVFontButtonParts.Click += new EventHandler(lVFontButtonParts_Click);
            this.outWardOption.lVOriginalFontButtonParts.Click += new EventHandler(lVOriginalFontButtonParts_Click);
            this.outWardOption.lVBackColorButtonParts.Click += new EventHandler(lVBackColorButtonParts_Click);
            this.outWardOption.lVBackColor2ButtonParts.Click += new EventHandler(lVBackColor2ButtonParts_Click);

            this.outWardOption.lVSelectForeColorButtonParts.Click += new EventHandler(lVSelectForeColorButtonParts_Click);
            this.outWardOption.lVSelectBackColorButtonParts.Click += new EventHandler(lVSelectBackColorButtonParts_Click);

            this.outWardOption.lVColmunFColorButtonParts.Click += new EventHandler(lVColmunFColorButtonParts_Click);
            this.outWardOption.lVColmunBColorButtonParts.Click += new EventHandler(lVColmunBColorButtonParts_Click);

            this.outWardOption.lVResetButtonParts.Click += new EventHandler(formResetButtonParts_Click);

            ///
            this.outWardOption.lVFontButtonParts.Click += new EventHandler(ChangeFlag);
            //this.outWardOption.lVOriginalFontButtonParts.Click += new EventHandler(ChangeFlag);
            this.outWardOption.lVBackColorButtonParts.Click += new EventHandler(ChangeFlag);
            this.outWardOption.lVBackColor2ButtonParts.Click += new EventHandler(ChangeFlag);

            this.outWardOption.lVSelectForeColorButtonParts.Click += new EventHandler(ChangeFlag);
            this.outWardOption.lVSelectBackColorButtonParts.Click += new EventHandler(ChangeFlag);

            this.outWardOption.lVColmunFColorButtonParts.Click += new EventHandler(ChangeFlag);
            this.outWardOption.lVColmunBColorButtonParts.Click += new EventHandler(ChangeFlag);

            this.outWardOption.lVResetButtonParts.Click += new EventHandler(ChangeFlag);
        }
        public void ResetEvent()
        {
            this.outWardOption.lVFontButtonParts.Click -= new EventHandler(lVFontButtonParts_Click);
            this.outWardOption.lVOriginalFontButtonParts.Click -= new EventHandler(lVOriginalFontButtonParts_Click);
            this.outWardOption.lVBackColorButtonParts.Click -= new EventHandler(lVBackColorButtonParts_Click);
            this.outWardOption.lVBackColor2ButtonParts.Click -= new EventHandler(lVBackColor2ButtonParts_Click);

            this.outWardOption.lVSelectForeColorButtonParts.Click -= new EventHandler(lVSelectForeColorButtonParts_Click);
            this.outWardOption.lVSelectBackColorButtonParts.Click -= new EventHandler(lVSelectBackColorButtonParts_Click);

            this.outWardOption.lVColmunFColorButtonParts.Click -= new EventHandler(lVColmunFColorButtonParts_Click);
            this.outWardOption.lVColmunBColorButtonParts.Click -= new EventHandler(lVColmunBColorButtonParts_Click);

            this.outWardOption.lVResetButtonParts.Click -= new EventHandler(formResetButtonParts_Click);

            ///
            this.outWardOption.lVFontButtonParts.Click -= new EventHandler(ChangeFlag);
            //this.outWardOption.lVOriginalFontButtonParts.Click -= new EventHandler(ChangeFlag);
            this.outWardOption.lVBackColorButtonParts.Click -= new EventHandler(ChangeFlag);
            this.outWardOption.lVBackColor2ButtonParts.Click -= new EventHandler(ChangeFlag);

            this.outWardOption.lVSelectForeColorButtonParts.Click -= new EventHandler(ChangeFlag);
            this.outWardOption.lVSelectBackColorButtonParts.Click -= new EventHandler(ChangeFlag);

            this.outWardOption.lVColmunFColorButtonParts.Click -= new EventHandler(ChangeFlag);
            this.outWardOption.lVColmunBColorButtonParts.Click -= new EventHandler(ChangeFlag);

            this.outWardOption.lVResetButtonParts.Click += new EventHandler(ChangeFlag);
        }

        private void ChangeFlag(object sender, EventArgs e)
        {
            this.changeFlag = true;
        }

        //フォントのウィンドウを開く
        public void lVFontButtonParts_Click(object sender, EventArgs e)
        {
            FormFontSet formFontSet = new FormFontSet();
            if (true == FormGUI.GetFontData(formFontSet,this.outWardOption.LVFontName,this.outWardOption.LVFontSize,
                Color.FromArgb(this.outWardOption.LVForeColorRed,this.outWardOption.LVForeColorGreen,this.outWardOption.LVForeColorBlue)))
            {
                //ラベルを書き換える。実データは書き換えない
                this.outWardOption.sampleListViewParts.SetFont(formFontSet.formFontName, formFontSet.formFontSize);
                //一つ目と二つ目の色を変える
                byte[] rgb = { formFontSet.formForeColorRed, formFontSet.formForeColorGreen, formFontSet.formForeColorBlue};
                this.outWardOption.sampleListViewParts.SetItemForeColor(0, rgb);
                this.outWardOption.sampleListViewParts.SetItemForeColor(1, rgb);

                this.outWardOption.LVFontType = "installed";
            }
        }
        public void lVOriginalFontButtonParts_Click(object sender, EventArgs e)
        {
            originalFont = new OriginalFont(this.outWardOption.LVOriginalFontPath);
            originalFont.Show();
            originalFont.okButton.Click += new EventHandler(okButton_Click);

            FormFontSet formFontSet = new FormFontSet();

        }
        public void okButton_Click(object sender, EventArgs e)
        {
            FormFontSet formFontSet = new FormFontSet();

            try
            {
                //this.outWardOption.LVOriginalFontPath = originalFont.fontPath;
                //サイズを設定
                float a;
                if (float.TryParse(originalFont.sizeCBox.Text, out a) == true)
                    this.outWardOption.LVOriginalFontSize = float.Parse(originalFont.sizeCBox.Text);
                else
                    this.outWardOption.LVOriginalFontSize = 12.0f;

                this.outWardOption.pfc = new System.Drawing.Text.PrivateFontCollection();
                //オリジナルフォントを設定
                this.outWardOption.pfc.AddFontFile(originalFont.fontPath);
                this.outWardOption.LVOriginalFont= new Font(this.outWardOption.pfc.Families[0], this.outWardOption.LVOriginalFontSize);

                ////ラベルを書き換える。実データは書き換えない
                this.outWardOption.sampleListViewParts.Font = this.outWardOption.LVOriginalFont;
                //一つ目と二つ目の色を変える
                byte[] rgb = { originalFont.colorSet.red, originalFont.colorSet.green, originalFont.colorSet.blue };
                this.outWardOption.sampleListViewParts.SetItemForeColor(0, rgb);
                this.outWardOption.sampleListViewParts.SetItemForeColor(1, rgb);

                //内部データを書き換える
                this.outWardOption.tempLVoriginalFontPath = originalFont.fontPath;
                this.outWardOption.tempLVoriginalFontSize = this.outWardOption.LVOriginalFontSize;
                this.outWardOption.LVFontType = "original";

                this.changeFlag = true;
            }
            catch (System.IO.FileNotFoundException)
            {
                this.outWardOption.LVFontType = "installed";
            }
            catch
            {
                this.outWardOption.LVFontType = "installed";
            }
            originalFont.Dispose();
        }
        
        //背景色を得る
        public void lVBackColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //1行目を書き換える
                byte[] color = { colorSet.red, colorSet.green, colorSet.blue };
                this.outWardOption.sampleListViewParts.SetItemBackColor(0, color);
            }
        }
        //背景色2を得る
        public void lVBackColor2ButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //2行目を書き換える
                byte[] color = { colorSet.red, colorSet.green, colorSet.blue };
                this.outWardOption.sampleListViewParts.SetItemBackColor(1, color);
            }
        }
        //選択色の背景を得る
        public void lVSelectBackColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //3行目を書き換える
                byte[] color = { colorSet.red, colorSet.green, colorSet.blue };
                this.outWardOption.sampleListViewParts.SetItemBackColor(2, color);
            }
        }
        //選択色の文字を得る
        public void lVSelectForeColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                //3行目を書き換える
                byte[] color = { colorSet.red, colorSet.green, colorSet.blue };
                this.outWardOption.sampleListViewParts.SetItemForeColor(2, color);
            }
        }
        //カラムの文字色
        public void lVColmunFColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                byte[] color = { colorSet.red, colorSet.green, colorSet.blue };
                this.outWardOption.sampleListViewParts.SetColumnForeColor(color);
                this.outWardOption.sampleListViewParts.Refresh();
            }
        }
        //カラムの背景色
        public void lVColmunBColorButtonParts_Click(object sender, EventArgs e)
        {
            ColorSet colorSet = new ColorSet();
            if (true == FormGUI.GetColor(colorSet))
            {
                byte[] color = { colorSet.red, colorSet.green, colorSet.blue };
                this.outWardOption.sampleListViewParts.SetColumnBackColor(color);
                this.outWardOption.sampleListViewParts.Refresh();
            }
        }
        //リセットをする
        public void formResetButtonParts_Click(object sender, EventArgs e)
        {
            this.outWardOption.LVFontName = Const.opt.fontNameStd;
            this.outWardOption.LVFontSize = Const.opt.fontSizeStd;

            //カラム
            byte[] color = { SystemColors.Control.R, SystemColors.Control.G, SystemColors.Control.B};
            this.outWardOption.sampleListViewParts.SetColumnBackColor(color);
            color = new byte[] { SystemColors.WindowText.R, SystemColors.WindowText.G, SystemColors.WindowText.B};
            this.outWardOption.sampleListViewParts.SetColumnForeColor(color);

            //選択行
            color = new byte[] { SystemColors.Highlight.R, SystemColors.Highlight.G, SystemColors.Highlight.B};
            this.outWardOption.sampleListViewParts.SetItemBackColor(2, color);
            color = new byte[] { SystemColors.HighlightText.R, SystemColors.HighlightText.G, SystemColors.HighlightText.B };
            this.outWardOption.sampleListViewParts.SetItemForeColor(2, color);

            //偶数行と奇数行の色分け
            color = new byte[] { Color.White.R,Color.White.G,Color.White.B };
            this.outWardOption.sampleListViewParts.SetItemBackColor(0, color);
            color = new byte[] { Color.AliceBlue.R, Color.AliceBlue.G, Color.AliceBlue.B };
            this.outWardOption.sampleListViewParts.SetItemBackColor(1, color);

            this.outWardOption.LVFontType = "installed";
            this.outWardOption.sampleListViewParts.SetFont(Const.opt.fontNameStd, Const.opt.fontSizeStd);
            //一つ目と二つ目の色を変える
            color = new byte[] { SystemColors.WindowText.R, SystemColors.WindowText.G, SystemColors.WindowText.B };
            this.outWardOption.sampleListViewParts.SetItemForeColor(0, color);
            this.outWardOption.sampleListViewParts.SetItemForeColor(1, color);

            this.outWardOption.sampleListViewParts.Refresh();
        }

        public void SetAllOption()
        {
            if (changeFlag == true)
            {
                changeFlag = false;
                {
                    if (this.outWardOption.LVFontType.Equals("installed") == true)
                    {
                        this.outWardOption.LVFontName = this.outWardOption.sampleListViewParts.GetFontName();
                        this.outWardOption.LVFontSize = this.outWardOption.sampleListViewParts.GetFontSize();
                        this.outWardOption.LVOriginalFontPath = "None";
                        this.outWardOption.LVOriginalFontSize = 12.0f;
                    }
                    else if (this.outWardOption.LVFontType.Equals("original") == true)
                    {
                        this.outWardOption.LVFontName = "None";
                        this.outWardOption.LVFontSize = 12.0f;
                        this.outWardOption.LVOriginalFontPath = this.outWardOption.tempLVoriginalFontPath;
                        this.outWardOption.LVOriginalFontSize = this.outWardOption.tempLVoriginalFontSize;
                    }

                    //リストの文字色
                    this.outWardOption.LVForeColorRed = this.outWardOption.sampleListViewParts.GetItemForeColor(0)[0];
                    this.outWardOption.LVForeColorGreen = this.outWardOption.sampleListViewParts.GetItemForeColor(0)[1];
                    this.outWardOption.LVForeColorBlue = this.outWardOption.sampleListViewParts.GetItemForeColor(0)[2];

                    //リストの背景色の一つおき
                    this.outWardOption.LVBackColorRed = this.outWardOption.sampleListViewParts.GetItemBackColor(0)[0];
                    this.outWardOption.LVBackColorGreen = this.outWardOption.sampleListViewParts.GetItemBackColor(0)[1];
                    this.outWardOption.LVBackColorBlue = this.outWardOption.sampleListViewParts.GetItemBackColor(0)[2];

                    //リストの背景色の一つおき
                    this.outWardOption.LVBackColor2Red = this.outWardOption.sampleListViewParts.GetItemBackColor(1)[0];
                    this.outWardOption.LVBackColor2Green = this.outWardOption.sampleListViewParts.GetItemBackColor(1)[1];
                    this.outWardOption.LVBackColor2Blue = this.outWardOption.sampleListViewParts.GetItemBackColor(1)[2];

                    //選択されたリストの前景色
                    this.outWardOption.LVSelectForeColorRed = this.outWardOption.sampleListViewParts.GetItemForeColor(2)[0];
                    this.outWardOption.LVSelectForeColorGreen = this.outWardOption.sampleListViewParts.GetItemForeColor(2)[1];
                    this.outWardOption.LVSelectForeColorBlue = this.outWardOption.sampleListViewParts.GetItemForeColor(2)[2];

                    //選択されたリストの背景色
                    this.outWardOption.LVSelectBackColorRed = this.outWardOption.sampleListViewParts.GetItemBackColor(2)[0];
                    this.outWardOption.LVSelectBackColorGreen = this.outWardOption.sampleListViewParts.GetItemBackColor(2)[1];
                    this.outWardOption.LVSelectBackColorBlue = this.outWardOption.sampleListViewParts.GetItemBackColor(2)[2];

                    //カラムの文字色
                    this.outWardOption.LVColmunForeColorRed = this.outWardOption.sampleListViewParts.GetColumnForeColor()[0];
                    this.outWardOption.LVColmunForeColorGreen = this.outWardOption.sampleListViewParts.GetColumnForeColor()[1];
                    this.outWardOption.LVColmunForeColorBlue = this.outWardOption.sampleListViewParts.GetColumnForeColor()[2];
                    //カラムの背景色
                    this.outWardOption.LVColmunBackColorRed = this.outWardOption.sampleListViewParts.GetColumnBackColor()[0];
                    this.outWardOption.LVColmunBackColorGreen = this.outWardOption.sampleListViewParts.GetColumnBackColor()[1];
                    this.outWardOption.LVColmunBackColorBlue = this.outWardOption.sampleListViewParts.GetColumnBackColor()[2];

                    this.outWardOption.SaveListViewToFile();

                    //外観を変える
                    //ListViewPartsManager.ChangeOutWard();
                    //TreeViewPartsManager.ChangeOutWard();
                    //FormPartsManager.ChangeOutWard();
                }
            }
        }
    }
}
