﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;

namespace nispi.OptionControl
{
    //メール蘭をリンクにするか、アドレスクリックでのアプリ指定、メールクリックでアプリ指定
    //ブラウザの部分の外観、フォーマット
    class BrowserOption : BrowserOptionData
    {
        TabPageExParts tabPageParts;

        GroupBoxParts imageGboxParts;
        public RadioButtonParts imageOpenFileRButtonParts;
        public TextBoxParts imageOpenTBoxParts;
        public ButtonParts imageOpenButtonParts;
        public RadioButtonParts imageViewerRButtonParts;
        public RadioButtonParts imageUsuallyViewerRButtonParts;
        public RadioButtonParts imageNotOpenRButtonParts;
        public ButtonParts imageResetButtonParts;

        GroupBoxParts linkGboxParts;
        public RadioButtonParts linkOpenFileRButtonParts;
        public TextBoxParts linkOpenTBoxParts;
        public ButtonParts linkOpenButtonParts;
        public RadioButtonParts linkUseallyViewerRButtonParts;
        public RadioButtonParts linkNotOpenRButtonParts;
        public ButtonParts linkResetButtonParts;

        public OptionMainForm optionTabMain;

        public BrowserOptionEvent browserOptionEvent;
        public BrowserOption(OptionMainForm optionTabMain)
            : base()
        {
            this.optionTabMain = optionTabMain;

            float scaledFloat = Scale.GetScaledFloat(optionTabMain.fontSize);

            tabPageParts = new TabPageExParts();
            tabPageParts.SetFont(optionTabMain.fontName, scaledFloat);
            tabPageParts.Text = "ﾌﾞﾗｳｻﾞ ";
            tabPageParts.BorderStyle = System.Windows.Forms.BorderStyle.None;

            imageGboxParts = new GroupBoxParts();
            imageOpenFileRButtonParts = new RadioButtonParts();
            imageOpenTBoxParts = new TextBoxParts();
            imageOpenButtonParts = new ButtonParts();
            imageViewerRButtonParts = new RadioButtonParts();
            imageUsuallyViewerRButtonParts = new  RadioButtonParts();
            imageNotOpenRButtonParts =  new RadioButtonParts();
            imageResetButtonParts = new  ButtonParts();


            imageGboxParts.Location = new Point(10, 10);
            imageGboxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 160);
            imageGboxParts.SetFont(optionTabMain.fontName, scaledFloat);
            imageGboxParts.Text = "画像のアドレスのクリック時の動作";

            imageOpenFileRButtonParts.Location = new Point(20, 30);
            imageOpenFileRButtonParts.Size = new Size(120, 25);
            imageOpenFileRButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            imageOpenFileRButtonParts.Text = "特定のｿﾌﾄｳｪｱ";

            imageOpenTBoxParts.Location = new Point(150, 30);
            imageOpenTBoxParts.Size = new Size(280, 16);
            imageOpenTBoxParts.SetFont(optionTabMain.fontName, scaledFloat);

            imageOpenButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 30);
            imageOpenButtonParts.Size = new Size(100, 25);
            imageOpenButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            imageOpenButtonParts.Text = "ファイルを開く";

            imageViewerRButtonParts.Location = new Point(20, 60);
            imageViewerRButtonParts.Size = new Size(160, 25);
            imageViewerRButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            imageViewerRButtonParts.Text = "Ageonビューアを使用";
            imageViewerRButtonParts.Enabled = false;

            imageUsuallyViewerRButtonParts.Location = new Point(20, 90);
            imageUsuallyViewerRButtonParts.Size = new Size(160, 25);
            imageUsuallyViewerRButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            imageUsuallyViewerRButtonParts.Text = "通常のﾌﾞﾗｳｻﾞを使用";

            imageNotOpenRButtonParts.Location = new Point(20, 120);
            imageNotOpenRButtonParts.Size = new Size(160, 25);
            imageNotOpenRButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            imageNotOpenRButtonParts.Text = "アドレスを開かない";

            imageUsuallyViewerRButtonParts.Checked = true;

            imageResetButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 120);
            imageResetButtonParts.Size = new Size(100, 25);
            imageResetButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            imageResetButtonParts.Text = "元に戻す";

            tabPageParts.AddControl(imageGboxParts);

            imageGboxParts.AddControl(imageOpenFileRButtonParts);
            imageGboxParts.AddControl(imageOpenTBoxParts);
            imageGboxParts.AddControl(imageOpenButtonParts);
            imageGboxParts.AddControl(imageViewerRButtonParts);
            imageGboxParts.AddControl(imageUsuallyViewerRButtonParts);
            imageGboxParts.AddControl(imageNotOpenRButtonParts);
            imageGboxParts.AddControl(imageResetButtonParts);

            ///リンク
            ///
            linkGboxParts = new GroupBoxParts();
            linkOpenFileRButtonParts = new RadioButtonParts();
            linkOpenTBoxParts = new TextBoxParts();
            linkOpenButtonParts = new ButtonParts();
            linkUseallyViewerRButtonParts = new RadioButtonParts();
            linkNotOpenRButtonParts = new RadioButtonParts();
            linkResetButtonParts = new ButtonParts();

            linkGboxParts.Location = new Point(10, 180);
            linkGboxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 130);
            linkGboxParts.SetFont(optionTabMain.fontName, scaledFloat);
            linkGboxParts.Text = "アドレスのクリック時の動作";

            linkOpenFileRButtonParts.Location = new Point(20, 30);
            linkOpenFileRButtonParts.Size = new Size(120, 25);
            linkOpenFileRButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            linkOpenFileRButtonParts.Text = "特定のﾌﾞﾗｳｻﾞ";

            linkOpenTBoxParts.Location = new Point(150, 30);
            linkOpenTBoxParts.Size = new Size(280, 16);
            linkOpenTBoxParts.SetFont(optionTabMain.fontName, scaledFloat);

            linkOpenButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 30);
            linkOpenButtonParts.Size = new Size(100, 25);
            linkOpenButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            linkOpenButtonParts.Text = "ファイルを開く";

            linkUseallyViewerRButtonParts.Location = new Point(20, 60);
            linkUseallyViewerRButtonParts.Size = new Size(160, 25);
            linkUseallyViewerRButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            linkUseallyViewerRButtonParts.Text = "通常のﾌﾞﾗｳｻﾞを使用";

            linkNotOpenRButtonParts.Location = new Point(20, 90);
            linkNotOpenRButtonParts.Size = new Size(160, 25);
            linkNotOpenRButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            linkNotOpenRButtonParts.Text = "アドレスを開かない";

            linkNotOpenRButtonParts.Checked = true;

            linkResetButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 90);
            linkResetButtonParts.Size = new Size(100, 25);
            linkResetButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            linkResetButtonParts.Text = "元に戻す";

            tabPageParts.AddControl(linkGboxParts);

            linkGboxParts.AddControl(linkOpenFileRButtonParts);
            linkGboxParts.AddControl(linkOpenTBoxParts);
            linkGboxParts.AddControl(linkOpenButtonParts);
            linkGboxParts.AddControl(linkUseallyViewerRButtonParts);
            linkGboxParts.AddControl(linkNotOpenRButtonParts);
            linkGboxParts.AddControl(linkResetButtonParts);

            optionTabMain.optionTabControlParts.AddControl(tabPageParts);

            browserOptionEvent = new BrowserOptionEvent(this);
        }
        public void SetDataToGUI()
        {
            browserOptionEvent.ResetEvent();

            //IMAGE
            if (this.ImageBrowser.Equals("usually") == true)
                imageUsuallyViewerRButtonParts.Checked = true;

            else if (this.ImageBrowser.Equals("ageon") == true)
                imageViewerRButtonParts.Checked = true;

            else if (this.ImageBrowser.Equals("file") == true)
                imageOpenFileRButtonParts.Checked = true;

            else if (this.ImageBrowser.Equals("notopen") == true)
                imageNotOpenRButtonParts.Checked = true;
            else
            {
                this.ImageBrowser = "usually";
                imageUsuallyViewerRButtonParts.Checked = true;
            }

            if (this.ImageBrowserFile.Length > 0)
                imageOpenTBoxParts.Text = this.ImageBrowserFile;

            //LINK
            if (this.LinkBrowser.Equals("usually") == true)
                linkUseallyViewerRButtonParts.Checked = true;

            else if (this.LinkBrowser.Equals("file") == true)
                linkOpenFileRButtonParts.Checked = true;

            else if (this.LinkBrowser.Equals("notopen") == true)
                linkNotOpenRButtonParts.Checked = true;
            else
            {
                this.LinkBrowser = "usually";
                linkUseallyViewerRButtonParts.Checked = true;
            }

            if ((this.LinkBrowserFile.Length == 4) && (this.LinkBrowserFile.Equals("none")))
                linkOpenTBoxParts.Text = "";
            else if ((this.LinkBrowserFile.Length > 0) && (CheckFile(this.LinkBrowserFile) == true))
                linkOpenTBoxParts.Text = this.LinkBrowserFile;
            else
            {
                this.linkUseallyViewerRButtonParts.Checked = true;
                linkOpenTBoxParts.Text = "";
            }

            browserOptionEvent.SetEvent();
        }
    }
}