﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Net;
using System.IO;
using System.Threading;
using System.IO.Compression;
namespace nispi
{
    class DownloadByOfflaw2
    {
        public string httpResData;

        //public MemoryStream httpResRawData;
        public int httpResRawDataLength;

        private ManualResetEvent allDone;
        private int type;
        private string datUrl;

        public string command = "";

        const int BUFFER_SIZE = 4096;

        public DownloadByOfflaw2()
        {
            httpResData = "";
        }
        public void DownloadKakoLog(ref string responseStatusCode, ref string command, string datUrl, string offlaw2Address)
        {
            this.type = Util.BoardType(datUrl);
            this.datUrl = datUrl;

            allDone = new ManualResetEvent(false);

            Uri u = new Uri(offlaw2Address);

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(u);
            req.KeepAlive = false;
            req.ProtocolVersion = HttpVersion.Version11;
            req.Method = "GET";

            //ユーザーエージェント
            if (Const.opt.otherOption.UserAgent.Length > 0)
                req.UserAgent = Const.opt.otherOption.UserAgent;
            else
                req.UserAgent = Const.USER_AGENT;
            
            req.AutomaticDecompression = DecompressionMethods.GZip;
            req.Timeout = 10000;

            //プロクシ
            if ((Const.opt.otherOption.IsProxyUse.Equals("True") == true) &&
                (Const.opt.otherOption.ProxyAddress.Equals("none") == false) &&
                (Const.opt.otherOption.ProxyAddress.Length > 0))
            {
                WebProxy proxy = new WebProxy(
                    "http://" + Const.opt.otherOption.ProxyAddress + ":" + 
                    Const.opt.otherOption.ProxyPort);
                req.Proxy = proxy;
            }
            else
                req.Proxy = null;

            RequestState myRequestState = new RequestState();
            myRequestState.request = req;


            // Start the asynchronous request.
            IAsyncResult result =
              (IAsyncResult)req.BeginGetResponse(new AsyncCallback(RespCallback2), myRequestState);

            allDone.WaitOne();

            //次の動作を取得
            command = myRequestState.command;
            //エラーの数字を取得
            responseStatusCode = myRequestState.responseStatusCode;

            if (myRequestState.responseStatusCode.StartsWith("20") == true)
            {
                ;
            }
            else
            {
                myRequestState.response.Close();
                return;
            }

            //--受信したデータを見る
            if ((httpResData == null) || (httpResData.Length < 1))
            {
                myRequestState.response.Close();
                return;
            }

            string dir = Util.DatUrlToDatDirPath(this.datUrl);
            string dat_file_name = Util.DatUrlToDatFileName(this.datUrl);

            Downloader.save(dir, dat_file_name, httpResData);

            myRequestState.response.Close();
            return;
        }


        private void RespCallback2(IAsyncResult asynchronousResult)
        {
            try
            {
                RequestState myRequestState = (RequestState)asynchronousResult.AsyncState;
                HttpWebRequest myHttpWebRequest = myRequestState.request;
                //人大杉の時の処理、過去ログ入りの時
                if (true == myHttpWebRequest.Address.AbsoluteUri.Equals("http://www2.2ch.net/live.html"))
                {
                    myRequestState.responseStatusCode = "996";
                    myRequestState.command = "終了";
                    allDone.Set();
                    return;
                }
                try
                {
                    myRequestState.response = (HttpWebResponse)myHttpWebRequest.EndGetResponse(asynchronousResult);

                    //↓エラーでもなくＯＫとしてこのアドレスに転送される。（ヒット例：過去ログ倉庫入りのＤＡＴにアクセス、）
                    if (myRequestState.response.ResponseUri.AbsoluteUri.Equals("http://www2.2ch.net/nogood.html") == true)
                    {
                        myRequestState.responseStatusCode = "996";
                        myRequestState.command = "終了";
                        allDone.Set();
                        return;
                    }
                    //人大杉の時の処理
                    if (true == myHttpWebRequest.Address.AbsoluteUri.Equals("http://www2.2ch.net/live.html"))
                    {
                        myRequestState.responseStatusCode = "997";
                        myRequestState.command = "終了";
                        allDone.Set();
                        return;
                    }

                    if (myRequestState.response.StatusCode == HttpStatusCode.OK)
                    {
                        myRequestState.responseStatusCode = "200";
                        myRequestState.command = "終了";
                    }
                }
                catch (System.Net.WebException e)
                {
                    if (e.Response.ResponseUri.AbsoluteUri.Equals("http://www2.2ch.net/nogood.html") == true)
                    {
                        //今後のあらゆるエラーに備える。このアドレスならとりあえず終了
                        myRequestState.responseStatusCode = "996";
                        myRequestState.command = "終了";
                        allDone.Set();
                        return;
                    }

                    else if (e.Message.Contains("302") == true)
                    {
                        //見つからない

                        //Locationを見てボボン規制をチェックする。
                        /*
                         * ステータスが302であっても、応答ヘッダのLocationに
                         * http://*.2ch.net/_403/もしくはhttp://www2.2ch.net/403/があれば
                         * バーボン規制・ボボン規制として処理して下さい。
                         * http://www.monazilla.org/index.php?e=198
                         */
                        if (((e.Response.Headers[HttpResponseHeader.Location].Contains("2ch.net/_403/") == true) ||
                            (e.Response.Headers[HttpResponseHeader.Location].Contains("2ch.net/403/") == true)))
                        {
                            myRequestState.responseStatusCode = "403";
                            myRequestState.command = "終了";
                        }
                        else
                        {
                            myRequestState.responseStatusCode = "302";
                            myRequestState.command = "過去ログ①";
                        }
                        allDone.Set();
                        return;
                    }
                    else if (e.Message.Contains("403") == true)
                    {
                        //ぼぼん規制
                        myRequestState.responseStatusCode = "403";
                        myRequestState.command = "終了";
                        allDone.Set();
                        return;
                    }
                    else if (e.Message.Contains("404") == true)
                    {
                        //見つからない
                        myRequestState.responseStatusCode = "404";
                        myRequestState.command = "過去ログ①";
                        allDone.Set();
                        return;
                    }
                    else
                    {
                        //それ以外の場合
                        myRequestState.responseStatusCode = "999";
                        myRequestState.command = "終了";
                        //Const.debugForm.OutPutDebug("Other", e);
                        return;
                    }
                }
                catch
                {
                    //新規データが無い時にエラーが帰ることがある
                    myRequestState.responseStatusCode = "998";
                    myRequestState.command = "終了";
                    allDone.Set();
                    return;
                }
                Stream responseStream = myRequestState.response.GetResponseStream();
                myRequestState.streamResponse = responseStream;
                Stream st = myRequestState.streamResponse;
                try
                {
                    //読み込んでしまった本文を読み込む
                    //バイナリデータ
                    byte[] array = ReadBinaryData(st);
                    myRequestState.memoryStream.Write(array, myRequestState.offset, array.Length);
                    myRequestState.offset += array.Length;
                }
                catch { ;}

                IAsyncResult asynchronousInputRead = responseStream.BeginRead(myRequestState.BufferRead, 0, BUFFER_SIZE, new AsyncCallback(ReadCallBack2), myRequestState);
                return;
            }
            catch
            { ;}
        }


        private void ReadCallBack2(IAsyncResult asyncResult)
        {
            RequestState myRequestState = (RequestState)asyncResult.AsyncState;
            Stream st = myRequestState.streamResponse;

            byte[] array;
            try
            {
                //バイナリデータ
                array = ReadBinaryData(st);
                myRequestState.memoryStream.Write(array, myRequestState.offset, array.Length);
                myRequestState.offset += array.Length;

                if (array.Length > 0)
                {
                    try
                    {
                        IAsyncResult asynchronousResult = st.BeginRead(myRequestState.BufferRead, 0, BUFFER_SIZE, new AsyncCallback(ReadCallBack2), myRequestState);
                        st.Close();
                        return;
                    }
                    catch { ;}
                }
            }
            catch { ;}

            if (myRequestState.offset > 1)
            {
                //バイナリデータ
                MemoryStream ms = new MemoryStream(myRequestState.memoryStream.GetBuffer());
                //MemoryStream ms = new MemoryStream();
                //gzip.CopyTo(ms);

                //文字列データ
                //this.httpResData = myRequestState.responseData.ToString();

                if (Util.TYPE_JBBS == type)
                {
                    this.httpResRawDataLength = (int)ms.Length;
                    this.httpResData = System.Text.Encoding.GetEncoding("EUC-JP").GetString(ms.ToArray());
                }
                /*else if (Util.TYPE_OPEN2CH == type)
                {
                    this.httpResRawDataLength = (int)ms.Length;
                    this.httpResData = System.Text.Encoding.UTF8.GetString(ms.ToArray());
                }*/
                else
                {
                    this.httpResRawDataLength = (int)ms.Length;
                    this.httpResData = System.Text.Encoding.GetEncoding(932).GetString(ms.ToArray());
                }

                ms.Dispose();
            }

            myRequestState.streamResponse.Close();
            //myRequestState.response.Close();
            st.Close();

            allDone.Set();
        }

        public static byte[] ReadBinaryData(Stream st)
        {
            byte[] buf = new byte[32768]; // 一時バッファ

            using (MemoryStream ms = new MemoryStream())
            {

                while (true)
                {
                    // ストリームから一時バッファに読み込む
                    int read = st.Read(buf, 0, buf.Length);

                    if (read > 0)
                    {
                        // 一時バッファの内容をメモリ・ストリームに書き込む
                        ms.Write(buf, 0, read);
                    }
                    else
                    {
                        break;
                    }
                }
                // メモリ・ストリームの内容をバイト配列に格納
                return ms.ToArray();
            }
        }
    }
}