/*# Copyright (c) 2008 Hideki Ikemoto
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
/*# Copyright (c) 2014 Naoki MAEDA
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
#
# The above copyright notice and this permission notice shall be
# included in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
# NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
# LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
# OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
# WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * 
 * _E[h֘Ã\bh
*/
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Net;
using System.IO;
using System.Threading;

namespace nispi
{
    class Downloader
    {
        public static string load_dat(string dat_url)
        {
            string dir = Util.DatUrlToDatDirPath(dat_url);
            string dat_file_name = Util.DatUrlToDatFileName(dat_url);
            string str = "";

            try
            {
                using (FileStream fs = new FileStream(dir + Path.DirectorySeparatorChar + dat_file_name, FileMode.Open))
                {
                    using (StreamReader sr = new StreamReader(fs, System.Text.Encoding.Unicode))
                    {
                        str = sr.ReadToEnd();
                        sr.Close();
                        fs.Close();
                    }
                }
            }
            catch
            {
                return null;
            }
            return str;
        }

        public static void save(string dir, string file, string str)
        {
            if (Directory.Exists(dir) == false)
            {
                DirectoryInfo di = new System.IO.DirectoryInfo(dir);
                di.Create();
            }

            try
            {
                using (FileStream fsw = new FileStream(dir + Path.DirectorySeparatorChar + file, FileMode.Create))
                {
                    using (StreamWriter sw = new StreamWriter(fsw, System.Text.Encoding.Unicode))
                    {
                        sw.Write(str);
                        sw.Flush();
                        sw.Close();
                        fsw.Close();
                    }
                }
            }
            catch
            {
                return;
            }
        }


        public static void save_infomation(string dir, string file, string etag, string last_modified, string length)
        {
            if (Directory.Exists(dir) == false)
            {
                DirectoryInfo di = new System.IO.DirectoryInfo(dir);
                di.Create();
            }

            try
            {
                using (FileStream fsw = new FileStream(dir + Path.DirectorySeparatorChar + file, FileMode.Create))
                {
                    using (StreamWriter sw = new StreamWriter(fsw, System.Text.Encoding.Unicode))
                    {
                        sw.WriteLine(etag);
                        sw.WriteLine(last_modified);
                        sw.WriteLine(length);
                        sw.Flush();
                        sw.Close();
                        fsw.Close();
                    }
                }
            }
            catch
            {
                return;
            }
        }


        public static string get_info(string dir, string file, string kind)
        {
            if (System.IO.Directory.Exists(dir) == false)
            {
                DirectoryInfo di = new System.IO.DirectoryInfo(dir);
                di.Create();
            }

            try
            {
                using (FileStream fsr = new FileStream(dir + Path.DirectorySeparatorChar + file, FileMode.Open))
                {
                    using (StreamReader sr = new StreamReader(fsr, System.Text.Encoding.Unicode))
                    {
                        string etag = sr.ReadLine();
                        string last_modified = sr.ReadLine();
                        string length = sr.ReadLine();
                        
                        if ((length == null) || (length == ""))
                            length = "0";
                        
                        sr.Close();
                        fsr.Close();
                        if (kind == "size")
                            return length;
                        else if (kind == "etag")
                            return etag;
                        else if (kind == "last_modified")
                            return last_modified;
                        else
                            return null;
                    }
                }
            }
            catch
            {
                return null;
            }
        }
    }

    public class RequestState
    {
        // This class stores the State of the request.
        const int BUFFER_SIZE = 4096;
        public StringBuilder responseData;
        public byte[] BufferRead;
        public HttpWebRequest request;
        public HttpWebResponse response;
        public Stream streamResponse;
        public MemoryStream memoryStream;
        public int offset = 0;
        public string responseStatusCode = "";
        public string command = "";
        public RequestState()
        {
            BufferRead = new byte[BUFFER_SIZE];
            responseData = new StringBuilder("");
            memoryStream = new MemoryStream();
            request = null;
            streamResponse = null;
        }
    }
}
