﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.IO;
using System.Diagnostics;
using Microsoft.VisualBasic.FileIO;
using System.Windows.Forms;

namespace nispi
{
    class UpdateFileData
    {
        public int versionNum = 0;
        public string fileName = "";
        public string folderName = "";
        public string fileUrl = "";
        public int fileSize = 0;
        public string message = "";

        public UpdateFileData()
        {
        }
    }

    class GetUpdateFile
    {
        public GetUpdateFile()
        {          
        }
        public void BeginThread()
        {
            Thread t = new Thread(new ThreadStart(GetUpdateFileThread));
            t.IsBackground = true;
            t.Start();/**/
        }

        public void GetUpdateFileThread()
        {
            if (true)
            {
                try
                {
                    Thread.Sleep(10000);
                    // _AgeOnUpdate.exeがある時には書き換える
                    string srcFile = Const.CurrentDir + Path.DirectorySeparatorChar + "_AgeOnUpdate.exe";
                    if (FileIO.CheckIsFile(srcFile) == true)
                    {
                        string dstFile = Const.CurrentDir + Path.DirectorySeparatorChar + "AgeOnUpdate.exe";
                        FileSystem.MoveFile(
                            srcFile,
                            dstFile, true);

                        
                    }
                    DeleteUpdateFile(Const.CurrentDir + Path.DirectorySeparatorChar + "update");

                    //現在の情報ファイルを得る
                    UpdateFileData nowFileData = new UpdateFileData();
                    string nowFileDataStr = FileIO.ReadShiftJis("update", "update.txt");
                    if (GetFileData(nowFileData, nowFileDataStr) == false)
                        return;

                    //アップデートをチェックする
                    string downloadStr = "";
                    if (DownloadCheckFile(ref downloadStr) == false)
                        return;

                    UpdateFileData updateFileData = new UpdateFileData();
                    //アップデートの情報ファイルを得る
                    if (GetFileData(updateFileData, downloadStr) == false)
                        return;

                    //現在の情報ファイルとアップデートの情報ファイルを比べる
                    if (ComparerUpDateFileData(nowFileData, updateFileData) == false)
                        return;

                    //メッセージボックスを表示する
                    DialogResult result = MessageBox.Show("最新の更新ファイルがあります。\r\n更新しますか？",
                        "AgeOnの更新情報",
                        MessageBoxButtons.YesNo,
                        MessageBoxIcon.Information,
                        MessageBoxDefaultButton.Button2);

                    //何が選択されたか調べる
                    if (result == DialogResult.Yes)
                    {
                        //UpdateAgeOnを開始する
                        UpdateControl.StartUpdate();
                    }
                    else if (result == DialogResult.No)
                    {
                        return;
                    }

                    return;
                }
                catch
                {
                }
           
            }
        }
        public void DeleteUpdateFile(string updateFolder)
        {
            try
            {
                string[] subFolders = Directory.GetDirectories(updateFolder, "*", System.IO.SearchOption.TopDirectoryOnly);

                if (subFolders.Length != 0)
                {
                    foreach (string folder in subFolders)
                    {
                        Microsoft.VisualBasic.FileIO.FileSystem.DeleteDirectory(
                            folder, UIOption.OnlyErrorDialogs, RecycleOption.DeletePermanently);

                    }
                }
                string[] files = Directory.GetFiles(updateFolder);

                foreach (string file in files)
                {
                    if (file.EndsWith(".txt") == true)
                        continue;

                    FileSystem.DeleteFile(file, UIOption.OnlyErrorDialogs, RecycleOption.DeletePermanently);
                }
            }
            catch { ;}

        }
        public bool ComparerUpDateFileData(UpdateFileData nowFileData, UpdateFileData updateFileData)
        {
            if (nowFileData.versionNum < updateFileData.versionNum)
                return true;
            else if (updateFileData.versionNum == 0)
                return true;
            else
                return false;
        }

        public bool GetFileData(UpdateFileData updateFileData, string downloadStr)
        {
            string[] data = downloadStr.Split(',');
            int a = 0;
            
            //整数でなければfalse
            if (Int32.TryParse(data[0], out a) == false)
                return false;
            updateFileData.versionNum = Int32.Parse(data[0]);
            
            //AgeOnで始まってなければfalse
            if (data[1].StartsWith("AgeOn") == false)
                return false;
            updateFileData.fileName = data[1];
            updateFileData.folderName = data[1].Substring(0, data[1].Length - 4);
            updateFileData.fileUrl = "http://maedanaoki.jp/software/ageon/" + data[1];

            //int型にできなければfalse
            if (Int32.TryParse(data[2],out a) == false)
                return false;
            updateFileData.fileSize = Int32.Parse(data[2]);

            //長さが０ならfalse
            if (data[3].Length == 0)
                return false;
            updateFileData.message = data[3];

            return true;
        }

        public bool DownloadCheckFile(ref string downloadStr)
        {
            DownloadUpdateCheckFile ddk = new DownloadUpdateCheckFile();
            if (true == ddk.Download(Const.UPDATE_CHECK_URL))
            {
                downloadStr = ddk.httpResData;
                //FileIO.SaveShiftJis("update", "update.txt", downloadStr);
                return true;
            }
            else
            {
                return false;
            }
        }
    }
}
