<?php
// $Id: dbBase.inc,v 1.5 2004/07/16 11:11:40 atsushifx Exp $
/**
* DB³ܥ饹
*
* @package com.aglabo.aglib.dbobject
* @licence http://www.opensource.org/licenses/bsd-license.php
* @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
* @copyright Copyright (c) 2004 aglib Project
*/
require_once 'aglib.inc';
require_once 'agOptions.inc';
require_once 'DBO/DBO.inc';
// PEAR lib
require_once 'DB.php'; // PEAR DB

/**
* DBBase
* DB³Ѵܥ饹
*
* @author Furukaw Atsushi <atsushifx@aglabo.com>
* @version $Revision: 1.5 $
* @since r1.00
*/
// Database³
if (!defined("DBO_DATABASE")) {
    define("DBO_DATABASE", "mysql");
    define("DBO_USER",     "nobody");
    define("DBO_PASSWORD", "nobody");
    define("DBO_HOST",     "localhost");
    define("DBO_DBDB",     "aglib");
}

/**
* DB³ܥ饹
*
* ꤷǡ١³
*
* @author Furukaw Atsushi <atsushifx@aglabo.com>
* @version $Revision: 1.5 $
* @since 2004-01-26
*/
class dbBase extends agOptions {
    /**
    * @var DB DB³
    * @access private
    */
    var $_db = null;

    /**
    * @var DBO_xxx DBManager
    * @access pricate
    */
    var $_dbo = null;

    function dbBase()
    {
        $init = array(
            'database'  => DBO_DATABASE,
            'user'      => DBO_USER,
            'password'  => DBO_PASSWORD,
            'host'      => DBO_HOST,
            'dbdb'      => DBO_DBDB,
        );
        $this->agOptions($init, false, __CLASS__);
        $this->_db = $this->getOption("_db");
    }

    /**
    * Version
    *
    * @return number СʥС
    */
    function version()
    {
        return 1.00;
    }


    /**
    * ꤷץ󤫤DSN
    *
    * @access private
    * @return string DSN
    */
    function getDSN()
    {
        $database = $this->getOption("database");
        $user = $this->getOption("user");
        $password = $this->getOption("user");
        $host = $this->getOption("host");
        $db = $this->getOption("dbdb");

        $dsn =$database . "://" . $user;
        if ($password != '')  $dsn .= ':' . $password;

        if ($database=='pgsql' && $host=='localhost')  $host = '';
        $dsn .= '@' . $host . '/' . $db;
        return $dsn;
    }

    /**
    * DBO
    * @param DBOѤΥǡ١
    * @return DBO
    */
    function &dboFactory($database = "")
    {
        if ($database == "") {
            $database = $this->getOption("database");
        }
        $dbo = DBO::factory($database);
        return $dbo;
    }

    /**
    * DB³Ƥ뤫å
    * @return true:³Ƥ롿false:³Ƥʤ
    */
    function isConnected()
    {
        return DB::isConnection($this->_db);
    }

    /**
    * DB³
    *
    * @return DB_:³false:³
    */
    function connect()
    {
        if ($this->_dbo == null) {
            $this->_dbo = $this->dboFactory();
        }
        if ($this->isConnected()) return $this->_db;
        $dsn = $this->getDSN();
        $db = DB::connect($dsn);
        if (DB::isError($db))     return false;
        $db->autoCommit(false);
        $this->_db = $db;
        $this->setOption("_db", $this->_db);
        return $db;
    }

    /**
    * DBߥå
    */
    function commit()
    {
        return  $this->_db->commit();
    }

    /**
    * DBХå
    */
    function rollback()
    {
        return $this->_db->rollback();
    }

    /**
    * ꤷơ֥Υե
    * @param string  ơ֥̾
    * @return string[] ե
    */
    function getFields($table)
    {
        if (!$this->connect())  return false;
        $list = $this->_dbo->getFields($this->_db, $table);
        return $list;
    }
}

/**
* dbObjectѥ顼ϥɥ󥰥饹
*
* @version $Revision: 1.5 $
* @author Furukawa Atsushi <atsushifx@aglabo.com>
* @package com.aglabo.aglib.dbobject
* @licence http://www.opensource.org/licenses/bsd-license.php
* @since 1.00
*/
class dbObject_Error extends agError {
    /**
    * @var string[] 顼åɲѡ
    */
    var $add_message = array(
        'AGERR_DB0101' => 'illegal db',
        'AGERR_DB0102' => "illegal field",
        'AGERR_DB0110' => "can't get field define",
        'AGERR_DB0111' => "type undefined",
    );
}
?>
