<?php
// $Id: dbObject.inc,v 1.1.1.1 2004/05/05 09:10:27 atsushifx Exp $
require_once 'aglib.inc';
require_once 'dbBase.inc';

/**
* DBObject
* ơ֥ιܤƩŪ˰饹
* @author Furukaw Atsushi <atsushifx@aglabo.com>
* @version $Revision: 1.1.1.1 $
* @package com.aglabo.aglib.dbobject
* @licence http://www.opensource.org/licenses/bsd-license.php
* @access public
* @since 2003/9/19
*/
class dbObject extends dbBase {
	/** @var string ơ֥̾ */
	var $dbtable;

	/**
	* @access private
	* @var string[]	ơ֥Υեɰ
	*/
	var $_fieldList = null;

	/**
	* 󥹥ȥ饯
	* @param string ơ֥̾
	*/
	function dbObject($table)
	{
		$this->dbBase();
		if ($table != "") {
			$this->dbtable = $table;
		}
	}

	/**
	* Version
	* @return number Versin Number
	*/
	function version()
	{
		return 1.00;
	}

	/**
	* ơ֥Υեɤ
	* @param mixed $id ID
	*/
	function fieldInit($id = null, $id2 = null)
	{
		if ($id == null) {
			$er = $this->clearFields();
		} else {
			if (is_array($id)) {
				$er = $this->assocFields($id);
			} else {
				$er = $this->get($id, $id2);
			}
		}
		return $er;
	}

	/**
	* ꤹ
	* @access private
	* @param string ̾
	* @param string 
	* @return string (ɬפʤquote)
	*/
	function _setValue($key, $value)
	{
		if ($key == "")	return null;
		if (is_null($value))	return 'null';
		switch ($this->_fieldList[$key]) {
		case "int":
			if (!is_numeric($value))	return null;
			$value = $value;
			break;
		default:
			$value = $this->_db->Quote($value);
			break;
		}
		return $value;
	}

	/**
	* 1ɤߤ
	* @param string ޤID
	* @param string ID(optional)
	* @return mixed DBObject:ɤ߹ԡfalse:ɤ߹߼
	*/
	function get($keyorvalue, $value = null)
	{
		$this->clearFields();
		if ($keyorvalue=="")	return false;
		if ($value == null) {
			$key = key($this->_fieldList);
			$value = $keyorvalue;
		} else {
			$key = $keyorvalue;
		}
		if (!isset($this->_fieldList[$key]))	return aglib::raiseError('AGERR_DB0102');
		$value = $this->_setValue($key, $value);
		$sql = "select *
		from " . $this->dbtable . "
		where $key = $value";
		$fetch = $this->_db->GetRow($sql, null, DB_FETCHMODE_ASSOC);
		if (DB::isError($fetch))	return false;
		return $this->assocFields($fetch);
	}

	/**
	* ͤDB˿Ͽ(insert)
	* @param string[](&optional) ϿԤ̾Υꥹ
	* @return mixed DB_OK:ϿDB_ERROR:Ͽ
	*/
	function insert($fields = null)
	{
		$fields = $this->getFields($fields);
		if (!$fields)	return false;
		$keys = "";
		$values = "";
		foreach ($fields as $key => $type)	{
			$value = $this->_setValue($key, $this->$key);
			if ($keys != "")	$keys .= ", ";
			$keys .= $key;
			if ($values != "")	$values .= ", ";
			$values .= $value;
		}
		$sql = "insert into {$this->dbtable}
			($keys)
		values (
			$values
		)";
		return $this->_db->query($sql);
	}

	/**
	* ͤDB˹(update)
	* @param string[](&optional) ϿԤ̾Υꥹ
	* @return mixed DB_OK:ϿDB_ERROR:Ͽ
	*/
	function update($fields = null)
	{
		$fields = $this->getFields($fields);
		if (!$fields)	return	false;
		$update = "";
		$where = "";
		foreach ($this->_fieldList as $key => $type)	{
			$value = $this->_setValue($key, $this->$key);
			if ($where == "") {
				$where = "$key = $value";
			} else {
				if ($update != "")	$update .= ", ";
				$update .= "$key = $value";
			}
		}
		$sql = "update {$this->dbtable}
		set $update
		where $where";
		return $this->_db->query($sql);
	}

	/**
	* ͤDBϿ
	* @param string[](&optional) ϿԤ̾Υꥹ
	* @return mixed DB_OK:ϿDB_ERROR:Ͽ
	*/
	function regist($fields = null)
	{
		if (!$this->isExist()) {
			return $this->insert($fields);
		} else {
			return $this->update($fields);
		}
	}



	/**
	* 쥳ɤDB
	* @return mixed DB_OK:DB_ERROR:
	*/
	function delete()
	{
		return $this->kill();
	}

	/**
	* 쥳ɤDB
	* @return mixed DB_OK:DB_ERROR:
	*/
	function kill()
	{
		if (!$this->getFields())	return	false;
		$key = key($this->_fieldList);
		$value = $this->_setValue($key, $this->$key);
		$sql = "delete from {$this->dbtable} where $key=$value";
		return $this->_db->query($sql);
	}

	/**
	* DBߥå
	*/
	function commit()
	{
		return	$this->_db->commit();
	}

	/**
	* DBХå
	*/
	function rollback()
	{
		return $this->_db->rollback();
	}

	/**
	* եɤNULLꥢ
	* @return bool true:ꥢ
	*/
	function clearFields()
	{
		$list = $this->getFields();
		if ($list == false)  return false;
		foreach ($list as $key => $value) {
			$this->$key = null;
		}
		return true;
	}

	/**
	* Ϣ󤫤եɤꤹ
	* @param array[]	ɤ߹Ϣ
	* @return DBOBject DBObject
	*/
	function assocFields($row)
	{
		if (!$this->getFields())	return false;
		foreach ($this->_fieldList as $key => $type)
		{
			if (isset($row[$key])) {
				if ($type == "int")	{	//
					$this->$key = (int)$row[$key];
				} else {
					$this->$key = $row[$key];
				}
			}
		}
		return $this;
	}

	/**
	* եɤͤꤷϢꤹ
	* @access public
	* @param mixed() Ϣ
	* @return mixed[]	ꤷϢ
	*/
	function assocArray(&$row)
	{
		if (!$this->getFields())	return false;

		foreach ($this->_fieldList as $key => $type)
		{
			switch ($type) {
			case "int":
				$row[$key] = intval($this->$key);
				break;

			default:
				$row[$key] = $this->$key;
				break;
			}
		}
		return $row;
	}

	/**
	* եɰ
	* @param string[](&optional)	եɥꥹ
	* @return string[] եɥꥹ/false:
	*/
	function getFields($fields = null)
	{
		if (!$this->connect())  return false;
		if ($this->_fieldList == null) {	// Ƥʤ
			$list = parent::getFields($this->dbtable);
			if (!$list)	return false;
			$this->_fieldList = $list;
		}

		reset($this->_fieldList);
		if ($fields == null)	return $this->_fieldList;
		if (!is_array($fields))	$fields = array($fields);
		$key = key($fields);
		if ($key != "0")	$fields = array_keys($fields);
		$fieldlist = array();
		$key = key($this->_fieldList);
		if (!in_array($key, $fields))	$fields = array_merge($key, $fields);
		for ($i=0; $i<count($fields); $i++) {
			$key = $fields[$i];
			if (!isset($this->_fieldList[$key]))	return false;
			$fieldlist[$key] = $this->_fieldList[$key];
		}
		reset($fieldlist);
		return $fieldlist;
	}

	/**
	* Ԥ뤫å
	* @param string(&optional) null/ID/
	* @param string(&optional) null/ID
	* @return bool true:Ԥ꡿false:Ԥʤ
	*/
	function isExist($keyorid = "", $id = "")
	{
		if (!$this->getFields())	return	false;
		if ($id != "") {
			$key = $keyorid;
		} else {
			$key = key($this->_fieldList);
			$id = $keyorid;
			if ($id == "")	$id = $this->$key;
		}
		if ($id == "")	return false;
		$value = $this->_setValue($key, $id);
		$sql = "select $key from " . $this->dbtable . " where $key=$value";
		$ret = $this->_db->GetOne($sql);
		if (DB::isError($ret))	return false;
		return ($ret != "");
	}

	/**
	* ꤷब¸ߤ뤫å
	* @param string ե̾
	*/
	function isFieldExists($fieldname)
	{
		if ($fieldname == "")	return false;
		$list = $this->getFields();
		return isset($list[$fieldname]);
	}
}
?>
