<?php
// $Id: dbObject.inc,v 1.4 2005/04/03 14:44:01 atsushifx Exp $
//
/**
 * DBO/Rޥåԥ󥰥饹
 *
 * ơ֥Υեɤ򥯥饹ΥСȤƥ륯饹
 * PHPѤδʰO/RޥåѡȤƻѤ
 *
 * @package jp.sf.aglib.dbobject
 *
 * @copyright Copyright &copy; 2004-2005 aglib Project
 * @licence http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @version $Revision: 1.4 $
 * @since   1.00
 * @create  2004-05-05
 */
// aglib
require_once 'aglib.inc';
// aglib
require_once 'agDA.inc';
require_once 'DB/dbBase.inc';

/**
 * DBObject
 *
 * ơ֥ΥǡϤԤʰO/Rޥåѡ
 * ơ֥Υե̾Ʊ̾Υ饹եɤͤ
 * ꡿Ǥ
 *
 * @version $Revision: 1.4 $
 * @since   1.00
 * @create  2003--9-19
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 */
class dbObject extends dbBase {
    /**
     *
     * @var string ơ֥̾
     */
    var $dbtable;

    /**
     * @var agDA    ǡ
     */
   var $da;

    /**
    * @access private
    * @var string[] ơ֥Υեɰ
    */
    var $_fieldList = null;

    /**
     * 󥹥ȥ饯
     *
     * ơ֥ȥСPrefixꤹ
     *
     * @param string ơ֥̾
     * @param string (='') Сץե
     */
    function dbObject($table, $prefix='')
    {
        $this->da = new agDA($prefix);
        $this->dbBase();
        $this->dbtable = $table;
    }

    /**
     * Version
     * @return string   СNo
     */
    function version()
    {
        return '1.10';
    }

    /**
     * Сץե
     *
     * @void
     * @return string   Сץե
     */
    function getPrefix()
    {
        return $this->da->getPrefix();
    }

    /**
    * ơ֥Υեɤ
    * @param mixed $id ID
    */
    function fieldInit($id = null, $id2 = null)
    {
        if ($id == null) {
            $er = $this->clearFields();
        } else {
            if (is_array($id)) {
                $er = $this->assocFields($id);
            } else {
                $er = $this->get($id, $id2);
            }
        }
        return $er;
    }

    /**
    * ꤹ
    * @access private
    * @param string ̾
    * @param string 
    * @return string (ɬפʤquote)
    */
    function _setValue($key, $value)
    {
        if ($key == "") return null;
        if (is_null($value))    return 'null';
        switch ($this->_fieldList[$key]) {
        case "integer":
            if (!is_numeric($value))    return null;
            $value = $value;
            break;
        default:
            $value = $this->_db->Quote($value);
            break;
        }
        return $value;
    }

    /**
    * 1ɤߤ
    * @param string ޤID
    * @param string ID(optional)
    * @return mixed DBObject:ɤ߹ԡfalse:ɤ߹߼
    */
    function get($keyorvalue, $value = null)
    {
        $this->clearFields();
        if ($keyorvalue=="")                    return aglib::raiseError('AGERR_DB_NOKEY');
        $fieldList = $this->getFields();
        if (aglib::isError($fieldList))         return $fieldList;

        $keys = $this->da->getSearchKey($this,  $fieldList, $keyorvalue, $value);
        if (aglib::isError($keys))              return $keys;
        $key = key($keys);
        $value = $this->_setValue($key, $keys[$key]);
        $sql = "select * from " . $this->dbtable . " where $key = $value";
        $fetch = $this->getRow($sql, null, DB_FETCHMODE_ASSOC);
        if (DB::isError($fetch))    return $fetch;
        return $this->assocFields($fetch);
    }

    /**
     * DBinsert
     *
     * DBΥǡ򿷵Ͽ(insert)
     *
     * @param string[](&optional)   ϿԤ̾Υꥹ
     * @return mixed DB_OK:ϿDB_ERROR:Ͽ
     */
    function insert($fieldList = null)
    {
        $fieldList = $this->getFields($fieldList);
        if (aglib::isError($fieldList))     return $fieldList;
        $prefix = $this->da->makePrefix();
        $keys = "";
        $values = "";
        foreach ($fieldList as $key => $type)  {
            $fields = $prefix . $key;
            $value = $this->_setValue($key, $this->$fields);
            if ($keys != "")    $keys .= ", ";
            $keys .= $key;
            if ($values != "")  $values .= ", ";
            $values .= $value;
        }
        $sql = "insert into {$this->dbtable}
            ($keys)
        values (
            $values
        )";
        return $this->query($sql);
    }

    /**
     * ͤDB˹(update)
     * @param string[](&optional) ϿԤ̾Υꥹ
     * @return mixed DB_OK:ϿDB_ERROR:Ͽ
     */
    function update($fields = null)
    {
        $fieldList = $this->getFields($fields);
        if (aglib::isError($fieldList))     return  $fieldList;
        $prefix = $this->da->makePrefix();
        $update = "";
        $where = "";
        foreach ($fieldList as $key => $type)    {
            $field = $prefix . $key;
            $value = $this->_setValue($key, $this->$field);
            if ($where == "") {
                $where = "$key = $value";
            } else {
                if ($update != "")  $update .= ", ";
                $update .= "$key = $value";
            }
        }
        $sql = "update {$this->dbtable}
        set $update
        where $where";
        return $this->query($sql);
    }

    /**
     * ͤDBϿ
     * @param string[](&optional) ϿԤ̾Υꥹ
     * @return mixed DB_OK:ϿDB_ERROR:Ͽ
     */
    function regist($fields = null)
    {
        if (!$this->isExist()) {
            return $this->insert($fields);
        } else {
            return $this->update($fields);
        }
    }



    /**
    * 쥳ɤDB
    * @return mixed DB_OK:DB_ERROR:
    */
    function delete()
    {
        return $this->kill();
    }

    /**
    * 쥳ɤDB
    * @return mixed DB_OK:DB_ERROR:
    */
    function kill()
    {
        $fieldList = $this->getFields();
        if (aglib::isError($fieldList)) return $fieldList;
        $keys = $this->da->getSearchKey($this, $fieldList);
        if (aglib::isError($keys))      return $keys;
        $key = key($keys);
        $value = $this->_setValue($key, $keys[$key]);
        $sql = "delete from {$this->dbtable} where $key=$value";
        return $this->query($sql);
    }

    /**
    * եɤNULLꥢ
    *
    * @param void
    * @return bool  true:ꥢ
    *               agError: 顼ȯ
    *
    */
    function clearFields()
    {
        $list = $this->getFields();
        if (aglib::isError($list))  return $list;
        $this->da->initField($this, $list);
        return true;
    }

    /**
    * Ϣ󤫤եɤꤹ
    *
    * ѥ᡼˻ꤷϢ󤫤饯饹Υեɤͤ򥳥ԡ롣
    * ץեꤷϥץեԤΤѤ롣
    *
    * @param array[]            ɤ߹Ϣ
    * @param string(&optional)  ץե
    * @return DBOBject DBObject/
    */
    function &assocFields($row, $prefix = '')
    {
        $fields = $this->getFields();
        if (aglib::isError($fields))    return $fields;

        $er = $this->da->toField($this, $row, $fields, $prefix);
        return $this;
    }

    /**
     * Ϣ
     *
     * 饹ΥեɤΥǡϢꤹ
     *
     * @param mixed()       ǡꤹϢ
     * @param string(&opt)  Prefix
     * @return mixed[]      ϢagError:꼺
     *
     */
    function &assocArray(&$row, $prefix='')
    {
        $fields = $this->getFields();
        if (aglib::isError($fields))    return $fields;
        $er = $this->da->toAssoc($this, $row, $fields, $prefix);
        return $er;
    }

    /**
     * եɰ
     *
     * @param string[](&optional)   եɥꥹ
     *      <sub>ˤϻꤷեɤΤ߼</sub>
     * @return string[]             եɥꥹ/
     *      - agError:
     */
    function getFields($fields = null)
    {
        $er = $this->connect();
        if (aglib::isError($er))    return $er;

        if ($this->_fieldList == null) {    // Ƥʤ
            $fieldList = parent::getFields($this->dbtable);
            if (aglib::isError($er))    return $fieldList;
            $this->_fieldList = $fieldList;
        }

        reset($this->_fieldList);
        if ($fields == null)    return $this->_fieldList;

        if (!is_array($fields)){
            $fields = array($fields);
        }
        $key = key($fields);
        if ($key != "0")    $fields = array_keys($fields);
        $fieldlist = array();
        $key = key($this->_fieldList);
        if (!in_array($key, $fields))   $fields = array_merge($key, $fields);
        for ($i=0; $i<count($fields); $i++) {
            $key = $fields[$i];
            if (!isset($this->_fieldList[$key]))    return false;
            $fieldlist[$key] = $this->_fieldList[$key];
        }
        reset($fieldlist);
        return $fieldlist;
    }

    /**
     * ǡ¸ߥå
     *
     * Ԥ¸ߤ뤫å
     *
     * @param string(&optional) /ID
     *      - ID Υѥ᡼Τ߻ꤷȤϡбIDΥǡ¸ߤ뤫å
     *      -  Υѥ᡼Ȥߤ碌ꤷѥ᡼ǸԤ¸ߤ뤫å
     * @param string(&optional) ID
     *      - ѤID
     * @return bool true:Ԥ꡿false:ԤʤagError:顼
     */
    function isExist($keyorid = "", $id = "")
    {
        $fieldList = $this->getFields();
        if (aglib::isError($fieldList))     return $fieldList;

        $keys = $this->da->getSearchKey($this, $fieldList, $keyorid, $id);
        if (aglib::isError($keys))          return false;

        $key = key($keys);
        $value = $this->_setValue($key, $keys[$key]);
        $sql = "select $key from " . $this->dbtable . " where $key=$value";
        $ret = $this->getOne($sql);
        if (DB::isError($ret))  return false;
        return ($ret != "");
    }

    /**
    * ꤷब¸ߤ뤫å
    * @param string ե̾
    */
    function isFieldExists($fieldname)
    {
        $fieldname = trim($fieldname);
        if ($fieldname == "")   return false;
        $list = $this->getFields();
        return isset($list[$fieldname]);
    }
}
?>
