<?php
// $Id: DBO_pgsql.inc,v 1.4 2005/04/03 05:04:56 atsushifx Exp $
/**
 * PostgresDBOޥ͡
 *
 * DBObjectѤPostgresǤΥեɥꥹȼ̾ѴԤ
 *
 * @package jp.sf.aglib.dbobject.dbo
 *
 * @copyright Copyright &copy; 2004-2005 aglib Project
 * @license http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 * @since   0.10
 * @create  2004-07-29
 */
require_once 'DB/dbo/DBO.inc';

/**
 * postgresDBOޥ͡㥯饹
 *
 * postgresѤ˥եɰʤɤΥ桼ƥƥ᥽åɥ饹
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 * @version 1.00
 * @since   1.00
 * @create  2004-04-04
 */
class DBO_pgsql extends DBO {
    /**
    * ꤷDBơ֥Υեɰ
    */
    function getFields($db, $table)
    {
        if (!is_object($db) || (get_class($db)!= "db_pgsql")) return aglib::raiseError('AGERR_DB_ILLEGALDB');
        $table = trim($table);
        $sql = "select attnum, attname, typname, attlen
    from pg_class c, pg_attribute a, pg_type t
    where c.oid = a.attrelid and t.oid=a.atttypid and
                attnum > 0 and
                relname='$table'
    order by attnum";
        $res = $db->Query($sql);
        if (DB::isError($res))  return $ret;
        $fields = array();
        while ($row = $res->FetchRow(DB_FETCHMODE_ASSOC)) {
            $key = $row["attname"];
            $type = $this->convertType($row["typname"], $row["attlen"]);
            if (!$type)  return aglib::raiseError('AGERR_DB_TYPEUNDEF'); // Unknown Data Type
            $fields[$key] = $type;
        }
        if ($fields == array())  return aglib::raiseError('AGERR_DB_FIELDCANTGET');
        return $fields;
    }

    /**
    * ̾DB̤Υ̾Ѵ
    * @param string ̾(DB)
    * @param integer ǡ
    * @return string ̾(DB)
    */
    function convertType($type_org, $len)
    {
        $type = null;
        switch ($type_org){
        case "int":
        case "int2":
        case "int4":
            if ($len == 1) {
                $type = "boolean";
            } else {
                $type = "integer";
            }
            break;

        case "text":
        case "char":
        case "varchar":
            if ($len == 1) {
                $type = "boolean";
            } else {
                $type = "string";
            }
            break;

        case "date":
            $type = "date";
            break;

        case "time":
            $type = "time";
            break;

        case 'datetime':
        case 'timestamp':
            $type = 'datetime';
            break;

        case 'float':
        case 'double':
        case 'real':
            $type = 'real';
            break;

        case 'decimal':
        case 'money':
        case 'numeric':
            $type = 'decimal';
            break;

        default:
            $type = false;
        }
        return $type;
    }
}
?>
