<?php
// $Id: agOptions.inc,v 1.7 2005/04/02 17:43:51 atsushifx Exp $
//
/**
 * ƥ饹̤Υץꥯ饹
 *
 * ꤷ饹˥ץ/᥽åɤ륯饹
 * 饹ΥСꤷѾƻѤ
 *
 * @package com.aglabo.aglib
 * @copyright Copyright &copy; 2003-2005 aglib Project
 * @license http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @version $Revision: 1.7 $
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 * @since   1.00
 * @create  2004-05-05
 */
// aglib

/**
 * ץꥯ饹
 *
 * ʲΤ褦Ѥ
 * <code>
 * <?php
 * require_once 'agOptions.inc'
 *
 * class opt1 {
 *   var $_opt; // for agOptions
 *
 *   function opt1()
 *   {
 *     $init_options = array(
 *       "database=>"mysql",
 *       "user"=>"furukawa",
 *     $this->_opt = & agOptions::init($init_options);
 *   }
 *
 *   function getOption($name=null)
 *   {
 *     return $this->_opt->getOption($name);
 *   }
 *
 *   function setOption($name, $opt=null)
 *   {
 *     return $this->_opt->setOption($name. $opt);
 *   }
 * }
 * ?>
 * </code>
 *
 * @since   1.10
 */
class agOptions {
    /**
    * @access private
    * @var mixed[] ץArray
    */
    var $options;

    /**
    * 󥹥ȥ饯
    * @param string[] ץ
    */
    function agOptions($init_options)
    {
        $this->options = array();
        $this->setOption($init_options);
    }

    function & init($init_options, $force_init=false, $id=null)
    {
        $instacne =  null;
        if ($id == '') {
            $id = get_class($this);
        }
        
        if (empty($GLOBALS[AG_GLOBAL_KEY]["agOptions"][$id])) {
            $GLOBALS[AG_GLOBAL_KEY]["agOptions"][$id] = new agOptions($init_options);
        }
        $instance = & $GLOBALS[AG_GLOBAL_KEY]["agOptions"][$id];
        if ($force_init) {
            $instance->setOption($init_options);
        }
        return $instance;
    }
    
    
    /**
    * ץꤹ
    *
    * @param string[] ץArray
    * @return true
    */
    function &setOption($name, $value = null)
    {
        if ($name != null) {
            if (!is_array($name)) {
                $options = array();
                $options[$name] = $value;
            } else {
                $options = $name;
            }
            
            foreach ($options as $opt => $v) {
                $this->options[$opt] = $v;
            }
        }
        return $this->options;
    }

    /**
    * ץ
    *
    * @param string[] ץArray
    * @return true
    */
    function &unsetOption($options)
    {
        if ($options != null) {
            if (!is_array($options)) {
                $options = array($options);
            }
            foreach ($options as $key) {
                unset($this->options[$key]);
            }
        }
        return $this->options;
    }
    
    /**
    * ץ
    *
    * @param string ץ̾
    * @return mix   ץ
    */
    function &getOption($optname = null)
    {
        if (is_null($optname)) {
            $ret = &$this->options;
        } else {
            if (isset($this->options[$optname])) {
                $ret = &$this->options[$optname];
            } else {
                $ret = aglib::raiseError();
            }
        }
        return $ret;
    }
}
?>
