<?php
//
/**
 * aglibѴܥ饹
 *
 * aglibѤ˶ꤪӴܽꤹ
 *   - aglibѥ顼ϥɥ顼
 *   - aglibǶ̤˻Ȥ
 *   - aglib饤֥ɤ߹ߤ褦include_path
 *
 * @package jp.sf.aglib
 *
 * @copyright Copyright &copy; 2003-2005 <a href="http://aglib.sourceforge.jp/">aglib Project</a>
 * @license http://www.opensource.org/licenses/bsd-license.php
 * @license http://www.jp.freebsd.org/www.freebsd.org/ja/copyright/freebsd-license.html
 *
 * @since   0.10
 * @version $Revision: 1.1 $
 * @create  2003-12-10
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 */
// aglib饤֥
$basedir = aglib::basedir() . "/aglib";


// ---   ---
define('AG_GLOBAL_KEY', '_ag_global_key_');
define('AG_SESSION_KEY', '_ag_session_key_');


define('AG_PATH_SEP_UNIX', ':');
define('AG_PATH_SEP_WIN', ';');

// ѥ
define('AG_PATH_ABSOLUTE', 'ABSOLUTE');
define('AG_PATH_RELATIVE', 'RELATIVE');
define('AG_PATH_AGLIB', 'AGLIB');

// PATH_SEPARATOR
if (!defined('PATH_SEPARATOR')) {
    define('PATH_SEPARATOR', aglib::pathSeparator());
}

// --  --
// ѤPHPǥ쥯ȥ
aglib::setIncludePath(array('aglib', 'PEAR'));

// 饤֥
require_once 'PEAR.php';
// aglib
require_once 'agUtil.inc';
require_once 'agError.inc';


// ---  饹  ---
/**
 * aglib쥯饹
 *
 * aglibѤ˴Ū򤷤Ƥ륯饹
 *  - 饤֥γƼ
 *  - aglibγƥ饹饤֥ɤ߹ߤ褦include_pathꤹ
 *
 * @version 1.10.02
 * @create  2005-03-28
 *
 * @author  Furukawa Atsushi <atsushifx@aglabo.com>
 *
 */
class aglib {
    /**
     * ԡ饤Ȥ
     *
     * @param void
     * @return string copyrightå
     */
    function copyright()
    {
        $copyright = 'Copyright &copy; 2003-2005';
        $copyright .= ' by <a href="' . 'http://aglib.sourceforge.jp/' . '">aglib Proejct</a>';
        return $copyright;
    }

    /**
     * Сֹμ
     *
     * @param void
     * @return string Сֹ
     */
    function version()
    {
        return '1.10.03';
    }

    /**
     * 饤֥ɤ߹Ѥ˥١ǥ쥯ȥ
     * @return string libraryɤ߹ߴǥ쥯ȥ
     */
    function baseDir()
    {
        $path = __FILE__;
        return dirname($path);
    }

    /**
     * 󥳡ɥåʸ֤
     *
     * @param string void
     * @return string void
     */
    function encodeString()
    {
        return "ͭ";
    }

    /**
     * ѥڤ
     *
     * PHP_OS򻲾ȤѥڤҤ
     */
    function pathSeparator($os = NULL)
    {
        if ($os == NULL) { $os = PHP_OS; }
        $os = strtoupper($os);
        if (preg_match('/^WIN/', $os)) {
            $sep = AG_PATH_SEP_WIN;
        } elseif (preg_match(':^OS/2:', $os)) {
            $sep = AG_PATH_SEP_WIN;
        } else {
            $sep = AG_PATH_SEP_UNIX;
        }
        return $sep;
    }

    /**
     * ѥ̤
     *
     * ꤷѥХѥХѥ饤֥ХѥΤɤǤ뤫
     *
     * @param string            ѥ
     * @param bool(&opt) = true 饤֥Хåե饰(true:饤֥Фå)
     * @return int ѥ \
     *   ( AG_PATH_BASE:ǥ쥯ȥСAG_PATH_RELATIVE:Хǥ쥯ȥ꡿AG_PATH_ABSOLUTE; Хǥ쥯ȥ )
    */
    function pathType($path, $aglib_check=true)
    {
        $type = AG_PATH_RELATIVE;
        $patt_abs1 = '/^([A-Za-z]:)?[\\\\\/]/';
        if (preg_match($patt_abs1, $path)) {
            $type = AG_PATH_ABSOLUTE;
        } elseif ($aglib_check) {   // aglibФå
            $patt_relative1 = '/^[.]+[\\\\\/]/';
            $patt_relative2 = '/^[.]+$/';
            if ($path!='' && (preg_match($patt_relative1, $path) || preg_match($patt_relative2, $path))) {
            } else {
                $type = AG_PATH_AGLIB;
            }
        }
        return $type;
    }

    /**
     * ĥå
     *
     * ѥǥ쥯ȥβå
     * (åΤ:ǥ쥯ȥ䴰ʤ)
     *
     * @param string    åѥ
     * @param string(&opt)  ǥ쥯ȥ
     *
     * @access private
     */
    function _simpleAccessAllow($path, $basedir)
    {
        $basedir = realpath($basedir);
        $path = realpath($path);
        if ($basedir == $path) {
            $allow = true;
        } else {
            $basedir .= DIRECTORY_SEPARATOR;
            $check_path = substr($path, 0, strlen($basedir));
            $allow = ($check_path == $basedir);
        }
        return $allow;
    }


    /**
     * ĥå
     *
     * ѥǥ쥯ȥβå
     *
     * @param string    åѥ
     * @param string(&opt)  ǥ쥯ȥ
     */
    function isAccessAllow($path, $basedir = null)
    {
        $allow = aglib::_simpleAccessAllow($path, $basedir);
        return $allow;
    }

    /**
     * ѥ䴰
     *
     * ѥAGLIBХǥ쥯ȥξ硢AGLIBǥ쥯ȥղä
     * (䴰ΤߡåϤʤ)
     *
     * @param string Υѥ̾
     * @return string ºݤΥѥ
     *
     * @access private
     */
    function _simpleLibPath($path)
    {
        $basedir = aglib::basedir();
        if ($path == '') {
            $path = $basedir;
        } else {
            $type = aglib::pathType($path);
            if ($type == AG_PATH_AGLIB){
                $path = realpath($basedir . DIRECTORY_SEPARATOR . $path);
            }
        }
        return $path;
    }

    /**
     * ѥ䴰
     *
     * ѥAGLIBХǥ쥯ȥξ硢AGLIBǥ쥯ȥղä
     *
     * @param string Υѥ̾
     * @return string ºݤΥѥ
     */
    function getLibPath($path)
    {
        $path = aglib::_simpleLibPath($path);
        return $path;
    }

    /**
     * 饤֥ɤ߹ߥѥꤹ
     *
     * @param string[]  ǥ쥯ȥꥹ
     * @param bool(&opt)    ǥ쥯ȥɲåե饰
     *     (true:Υǥ쥯ȥɲáfalse:Ͽ)
     * @return ꤹ륤󥯥롼ɥѥ
     */
    function setIncludePath($list, $add_defaultpath = true)
    {
        global $ag_Basedir;

        $includepath = 'include_path';
        $separator = aglib::pathSeparator();

        $add_defaultpathlist = array(
            $ag_Basedir,
            aglib::basedir(),
            );

        $dirlist = array_merge(
            array(".",),
            $add_defaultpathlist
            );
        if ($list) {
            if (!is_array($list)) { $list = array($list); }
            $dirlist = array_merge($dirlist, $list);
        }
        if ($add_defaultpath) {
            $list = explode($separator, ini_get($includepath));
            $dirlist = array_merge($dirlist, $list);
        }

        // ѥaglibТХѥ
        $dirlist_relative = array();
        $dirlist_abs = array();
       foreach ($dirlist as $path) {
            $type = aglib::pathType($path);
            $path = aglib::getLibPath($path);
            $path = preg_replace('/[\\/\\\\]/', DIRECTORY_SEPARATOR, $path);
            if ($type == AG_PATH_RELATIVE) {
                if (!in_array($path, $dirlist_relative)){ $dirlist_relative[] = $path; }
            } else {
                if (!in_array($path, $dirlist_abs)){ $dirlist_abs[] = $path; }
            }
        }
        $dirlist = array_merge($dirlist_relative, $dirlist_abs);
        $inc_path = implode($separator, $dirlist);
        ini_set('include_path', $inc_path);
        return $inc_path;
    }


    /**
     * LocationܤURL
     *
     * @param date      
     * @return string   
     */
    function location($path, $protocol='http', $is_location=true)
    {
        global $ag_BasePath;

        if ($protocol != 'https'){ $protocol ='http'; }
        $server = $_SERVER['SERVER_NAME'];
        if (aglib::pathType($path) != AG_PATH_ABSOLUTE) {
            $path  = dirname($_SERVER["PHP_SELF"]) . "/" . $path;
        } else {
            $path  = "/" . $ag_BasePath . $path;
        }
        $location = $protocol . "://". $server . $path;
        if ($is_location) {  header('Location: ' . $location);  }
        return $location;
    }

    /**
    * ǡERROR֥Ȥå
    *
    * @param  mixed       $data  åǡ
    * @param  int/string  $code  顼ɤΥå
    * @access  public
    * @return  bool       true:errorfalse:not error
    */
    function isError($data, $code=null)
    {
        return PEAR::isError($data, $code);
    }

    /**
     * aglibѥ顼åϥɥ顼
     *
     * @param string/int $code     顼
     * @param int        $mode     PEAR顼⡼(&optional)
     *   (PEAR_ERROR_RETURNPEAR_ERROR_PRINTPEAR_ERROR_TRIGGERPEAR_ERROR_DIEPEAR_ERROR_CALLBACKPEAR_ERROR_EXCEPTION)
     * @param mixed      $options  PHP󥿡ʥ륨顼٥
     * @param string     $userinfo ǥХå(ɲѡ
     * @return agError֥
     */
    function raiseError($code=null, $mode=null, $options=null, $userinfo=null, $error_class = null)
    {
        /**
        * errorϥɥ󥰥饹ꥹ
        */
        static $ClassList = array(
            "dbbase"    => "dbObject_Error",
            "dbobject"  => "dbObject_Error",
            "dblist"    => "dbObject_Error",
            "dbo_mysql" => "dbObject_Error",
            "dbo_pgsql" => "dbObject_Error",
        );

        if ($error_class == null) {
            if (isset($this))  $error_class = get_class($this);
            if (isset($ClassList[$error_class]))  $error_class = $ClassList[$error_class];
            if (!preg_match('/Error$/', $error_class)) $error_class .= '_Error';
        }
        if (!class_exists($error_class))  $error_class= 'agError';
        return PEAR::raiseError(null, $code, $mode, $options, $userinfo, $error_class, true);
    }
}
// TAB:4
// $Id: aglib.inc,v 1.1 2005/09/20 06:14:36 atsushifx Exp $
?>
