/* -*- c++ -*- */
#ifndef AKAXISO2_XML_SERIALIZER_DEFAULT_SERIALIZER_H__
#define AKAXISO2_XML_SERIALIZER_DEFAULT_SERIALIZER_H__

/** 
 * @file akaxiso2/XML/serializer/default_serializer.h
 * @brief default serializer
 */

#include <akaxiso2/configuration.h>
#include <akaxiso2/exception.h>
#include <akaxiso2/XML/serializer/xml_serializer_base.h>

namespace aka2 {

  /**
   * @brief transparent-formatter.
   *
   * This class has empty implementation of pure-virtual methods of aka2::formatter_base.\n
   * It works as a formatter, but it does not translate any encoding.
   */ 
  class default_formatter : public formatter_base {
  public:
    default_formatter() {}
    virtual ~default_formatter() {}

  private:
    virtual void set_encoding(const std::string &encoding);
    virtual ustring lcp_to_ucs2(const std::string &source);
    virtual void write(const ustring &entity);
  };

  /**
   * @brief XML serializer without encoding translation.
   *
   * default_serializer uses aka2::default_fomatter.
   * This is the simplest XML serializer without encoding translation.
   */
  class default_serializer : public xml_serializer_base {
  public:
    default_serializer();
  };

} // namespace aka2

#endif
