/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_OPERATORS_H__
#define AKAXISO2_FRAMEWORK_OPERATORS_H__

#include <akaxiso2/util/iosfwd.h> /* {g++2.96} */
#include <akaxiso2/framework/item.h>
#include <map>

namespace aka2 {

  class  member_type;
  struct member_types;
  struct member_map;
  class  attribute_type;
  typedef std::map<qname, itemtype, qname_less> item_types;

  /** marshalling text/value.  */
  struct value_op {
    virtual ~value_op() {} 
    virtual void write_text(const void* elm, 
                            std::ostream &ostm,
                            const preconditions &pcd) const = 0;
    virtual void read_text(void* elm, aka2::isstream &istm, 
                           const preconditions &pcd) const = 0;
  };


  struct member_types_getter {
    virtual ~member_types_getter() {}
    virtual const member_types &get_member_types() const = 0;
  };

  struct member_map_getter {
    virtual ~member_map_getter() {}
    virtual const member_map &get_member_map() const = 0;
  };


  /** Traits for SchemaTypes */
  struct simpletype_op : public element_op,
                         public value_op {
    virtual ~simpletype_op() {}
  };


  struct simplecontent_op : public element_op {
    virtual ~simplecontent_op() {}
    virtual const member_type& get_valuetype() const = 0;
  };


  struct sequence_op : public element_op, public member_types_getter {
    virtual ~sequence_op() {}
  };

  
  struct all_op : public element_op, public member_map_getter {};


  class item_iterator {
  public:
    virtual ~item_iterator(){}
    virtual bool has_next() const = 0;
    virtual const item *next() = 0;
  };

  struct choice_op : public element_op {
    virtual ~choice_op(){}
    virtual const item_types &get_item_types() const = 0;
    virtual size_t size(const void *container) const = 0;
    virtual void push(void *container, item &item) const = 0;
    virtual item_iterator* get_iterator(const void *container) const = 0;

    bool empty(const void *container) const {
      return size(container) == 0;
    }
  };


  class array_iterator {
  public:
    virtual ~array_iterator() {}
    virtual bool has_next() const = 0;
    virtual const void *next() = 0;
  };

  struct array_op : public element_op {
    virtual ~array_op(){}
    virtual const element_op& get_item_op() const = 0;
    virtual size_t size(const void *container) const = 0;
    virtual void push(void *container, void *element) const = 0;
    virtual array_iterator* get_iterator(const void *container) const = 0;
    bool empty(const void *container) const {
      return size(container) == 0;
    }
  };


  struct ptrmember_op : public element_op {
    virtual ~ptrmember_op() {}
 
    virtual schematype_id get_schematype() const { return ptrmember_id; }
    virtual size_t class_size() const { assert(!"Must not be called.");  return 0; }
    virtual const attribute_types *get_attribute_types() const { return 0; } 
    virtual const attribute_type* get_anyattr_type() const { return 0; }
    virtual void construct(void *e) const = 0;
    virtual void copy_construct(void *e, const void *src) const = 0;
    virtual void destruct(void *e) const = 0;
    virtual bool equals(const void *lhs, const void *rhs) const;

    virtual const element_op& get_value_op() const = 0;
    virtual void *dereference(void *elm) const = 0;
    virtual const void *dereference(const void *elm) const = 0;
    virtual void set(void *elm, void *v) const = 0;

    void *create_member(void *elm) const;
    bool is_null(const void *elm) const { return dereference(elm) == 0; }
  };

  /**
   * fixed
   */
  struct fixed_op : public element_op {
    virtual ~fixed_op() {}
    virtual schematype_id get_schematype() const { return fixed_id; }
    virtual bool equals(const void *lhs, const void *rhs) const { return true; }

    virtual void construct(void *e) const { get_value_op().construct(e); }
    virtual void copy_construct(void *e, const void *src) const { 
      get_value_op().copy_construct(e, src);  
    }
    virtual void destruct(void *e) const {
      get_value_op().destruct(e);
    }
    virtual size_t class_size() const { return get_value_op().class_size(); }

    virtual const attribute_types *get_attribute_types() const { return 0; }
    virtual const attribute_type *get_anyattr_type() const { return 0; }
    virtual const simpletype_op& get_value_op() const = 0;
  };

} // namespace aka2

#endif
