/* -*- c++ -*- */
#ifndef OSIXAKA2_GENERATOR_H__
#define OSIXAKA2_GENERATOR_H__

#include <akaxiso2/akaxiso2.h>
#include <osixaka2/classdefs.h>
#include <osixaka2/processor.h>
#include <fstream>

namespace osx {

  class output_file {
    std::string filename_;
    std::string outputdir_;
    static std::string escape_filename(const std::string &fn);
  public:
    output_file(const std::string &outputdir) : outputdir_(outputdir){}
    void open(const std::string &filename);
    void close();
    void write_include(const std::string &include_name);
    void write_system_include(const std::string &include_name);
    void write_header();
    void write_footer();
    void newline();
    std::ofstream ostm_;
    const std::string &get_filename() const { return filename_; }
  };

  class generator_base {
  protected:
    registry &registry_;
    registry_unit *regunit_;
    aka::id_type target_ns_id_;
  public:
    generator_base(registry &reg) 
      : registry_(reg), regunit_(0), target_ns_id_(aka::unregistered_token) { }

    std::string cppname(const aka::qname &name) const;
    std::string cppname(const std::string &name) const;
    std::string declname(const aka::qname &name) const;
    std::string declname(const std::string &name) const;
    std::string leafdecl(const aka::qname &name) const;
    std::string leafname(const aka::qname &name) const;
    std::string membername(const aka::qname &name) const;
    std::string membername(const std::string &name) const;
    std::string get_prefix(aka::id_type nsid) const;
    void set_unit(const unit_props &unit);
  };

  class generator : public generator_base {

    typedef std::vector<class_def*> class_def_array;

    mutable output_file &elm_;
    mutable output_file &xiso_;
    mutable output_file &ximpl_;

    bool use_soft_array_;

    qname_set resolved_;
  
    qname_set declared_leafs_;
    bool is_leaf_declared(const aka::qname &type) const;
    void leaf_declared(const aka::qname &type);
  
    bool soft_resolve(qname_set &resolving, const aka::qname &name, 
		      class_def_array &deps, qname_set &forwarded);
    bool hard_resolve(qname_set &resvolving, const aka::qname &name, 
		      class_def_array &deps, qname_set &processing);
  
    bool resolve_simpleType(const aka::qname &to_resolve, 
			    bool generate_source);

    bool resolve_complexType(const aka::qname &to_resolve, 
			     qname_set &toplevels,
			     bool force_hard_resolve,
			     bool generate_source);

    void resolve_one_unit(qname_set &simpleTypes, qname_set &topLevels, bool generate);
  
    void generate_sequence(const class_def &def);
    void generate_choice(const class_def &def);
    void generate_all(const class_def &def);
    void generate_array(const class_def &def);
    void generate_simplecontent(const class_def &def);
    void generate_simpletype(const class_def &def);

    void write_ptrmember_decl(const element_types &etypes) const; 

    void write_leaf_decl(const class_def &def, const std::string &leaftmp) const;
    void write_member_decls(const element_types &etypes) const;
    void write_attribute_decls(const attribute_defs &attrs) const;
    void write_member_leaves(const aka::qname &name, const element_types &etypes) const;
    void write_item_leaves(const aka::qname &name, const element_types &etypes) const;
    void write_attribute_leaves(const aka::qname &name, const attribute_defs &attrs) const;

    void begin_model_method(const aka::qname &name) const;
    void end_model_method() const;

    std::string get_ns_list(const std::string &nslist) const;

    void begin_namespace();
    void end_namespace();

  public:
    generator(registry &reg,
	      output_file &elm, output_file &xiso, output_file &ximpl,
	      bool use_soft_array) 
      : generator_base(reg), elm_(elm), xiso_(xiso), ximpl_(ximpl), 
	use_soft_array_(use_soft_array) {}

    void prepare();
    void resolve(const unit_props &unit, bool generate);

    void write_include(const std::string &basename) const;
    void open(const std::string &basename);
    void close();
  };

  class func_generator : public generator_base {
    mutable output_file &header_;
    mutable output_file &impl_;
    void begin_instantiate_xiso() const;
    void end_instantiate_xiso() const;
    void generate_instantiate_xiso();
    void generate_serialize_methods();
  public:
    func_generator(registry &reg, output_file &header, output_file &impl) 
      : generator_base(reg), header_(header), impl_(impl) {}
    void write_includes();
    void generate();
    void open(const std::string &basename);
    void close();
  };
}

#endif
