#include "preference_xiso.h"
#include <akaxiso2/akaxiso2.h>



namespace osp {

  void container_type_leaf::model() {
    /** attribute member definition. */
    attribute("type", &::osp::container_type::type_, xiso::leaf<std::string>()).required(true);
  }

  void escape_leaf::model() {
    /** attribute member definition. */
    attribute("to_escape", &::osp::escape::to_escape_, xiso::leaf<std::string>()).required(true);
    attribute("escaped", &::osp::escape::escaped_, xiso::leaf<std::string>()).required(true);
  }

  void format_leaf::model() {
    /** attribute member definition. */
    attribute("prefix", &::osp::format::prefix_, xiso::leaf<std::string>()).required(true);
    attribute("suffix", &::osp::format::suffix_, xiso::leaf<std::string>()).required(true);
  }

  void _namespace_leaf::model() {
    /** attribute member definition. */
    attribute("prefix", &::osp::_namespace::prefix_, xiso::leaf<std::string>()).required(true);
    attribute("uri", &::osp::_namespace::uri_, xiso::leaf<std::string>()).required(true);
  }

  void substitution_leaf::model() {
    /** attribute member definition. */
    attribute("original", &::osp::substitution::original_, xiso::leaf<std::string>()).required(true);
    attribute("substituted", &::osp::substitution::substituted_, xiso::leaf<std::string>()).required(true);
  }

  void simplecontent_value_type_leaf::model() {
    /** attribute member definition. */
    attribute("name", &::osp::simplecontent_value_type::name_, xiso::leaf<std::string>()).required(true);
  }

  void type_leaf::model() {
    /** element member definitions */
    member("cpp", &::osp::type::cpp_, xiso::leaf<std::string>());
    ptrmember("typedef", &::osp::type::typedef_, xiso::leaf<std::string>());
    ptrmember("leaf", &::osp::type::leaf_, xiso::leaf<std::string>());
    member("array", &::osp::type::array_, xiso::leaf<std::string>());
    ptrmember("array_typedef", &::osp::type::array_typedef_, xiso::leaf<std::string>());
    ptrmember("array_leaf", &::osp::type::array_leaf_, xiso::leaf<std::string>());
    /** attribute member definition. */
    attribute("name", &::osp::type::name_, xiso::leaf<std::string>());
  }

  void types_leaf::model() {
    /** element member definitions */
    member("type", &::osp::types::type_, ::osp::type_array_leaf(), 0, aka::unbounded);
  }

  void preference_leaf::model() {
    /** element member definitions */
    member("namespace", &::osp::preference::namespace_, ::osp::namespace_array_leaf(), 0, aka::unbounded);
    member("substitution", &::osp::preference::substitution_, ::osp::substitution_array_leaf(), 0, aka::unbounded);
    member("escape", &::osp::preference::escape_, ::osp::escape_array_leaf(), 0, aka::unbounded);
    member("choice_container", &::osp::preference::choice_container_, ::osp::container_type_leaf());
    member("array_container", &::osp::preference::array_container_, ::osp::container_type_leaf());
    member("member_format", &::osp::preference::member_format_, ::osp::format_leaf());
    member("array_format", &::osp::preference::array_format_, ::osp::format_leaf());
    member("simplecontent_value", &::osp::preference::simplecontent_value_, ::osp::simplecontent_value_type_leaf());
    member("nill_type", &::osp::preference::nill_type_, xiso::leaf<std::string>());
    member("builtins", &::osp::preference::builtins_, ::osp::types_leaf());
    member("user_types", &::osp::preference::user_types_, ::osp::types_leaf());
  }


}

