#include "XMLSchema_xiso.h"
#include <akaxiso2/util/string_funcs.h>

#include "schema_st.h"

namespace xs {

  void allNNI_leaf::write_text(const void *e, std::ostream &ostm,
			       const aka::preconditions &pcd) {
    const long &v = *static_cast<const long*>(e);
    if (v == aka::unbounded)
      ostm << "unbounded";
    else
      ostm << v;
  }
  
  void allNNI_leaf::read_text(void *e, aka2::isstream &istm, 
			      const aka::preconditions &pcd) {
    long &v = *static_cast<long*>(e);
    std::string val = aka2::trim(istm.rdbuf()->str());
    if (val == "unbounded") {
      v = aka::unbounded;
      return;
    }
    istm >> v;
    if (istm.fail())
      throw aka2::error(std::string("Failed to parse allNNI(maxOccurs) value.(")
			+ istm.rdbuf()->str() + ")",
			__FILE__, __LINE__);
  }

}
