//CUPPA:include=+
//CUPPA:include=-
#include <cppunit/extensions/HelperMacros.h>
#include <cppunit/TestAssert.h>

//CUPPA:namespace=+
//CUPPA:namespace=-

#include <akaxiso2/akaxiso2.h>
#include <akaxiso2/content_model.h>

namespace {

  typedef std::vector<aka2::item> any_choice;
  typedef std::vector<aka2::item> any_array_choice;
  typedef std::vector<aka2::item> anyType_choice;

  struct any_choice_leaf : aka2::sequential_choice<any_choice, any_choice_leaf> {
    void model() {
      occurrence(0, aka::unbounded);
      any("&any");
      item("value", xiso::leaf<std::string>());
    }
  };


  struct any_array_choice_leaf : aka2::sequential_choice<any_array_choice, any_array_choice_leaf> {
    void model() {
      occurrence(0, aka2::unbounded);
      any("&any", 0, aka2::unbounded);
      item("value", xiso::leaf<std::string>());
    }
  };

  struct anyType_choice_leaf : aka2::sequential_choice<anyType_choice, anyType_choice_leaf> {
    void model() {
      occurrence(0, aka2::unbounded);
      item("value", xiso::leaf<std::string>());
      any("any");
      any("any_array", 0, aka2::unbounded);
    }
  };
}



class anyChoiceTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(anyChoiceTest);
//CUPPA:suite=+
  CPPUNIT_TEST(test_serialize_choice);
  CPPUNIT_TEST(test_deserialize_choice);
  CPPUNIT_TEST(test_serialize_array_choice);
  CPPUNIT_TEST(test_deserialize_array_choice);
  CPPUNIT_TEST(test_anyType_choice);
//CUPPA:suite=-
  CPPUNIT_TEST_SUITE_END();
private:

  // your stuff...

public:

  virtual void setUp() {
    aka2::initialize();
    aka2::doctype("any_choice", any_choice_leaf());
    aka2::doctype("any_array_choice", any_array_choice_leaf());
    aka2::doctype("anyType_choice_test", anyType_choice_leaf());
  }

  virtual void tearDown() { 
    aka2::uninitialize();
  }

//CUPPA:decl=+
  void test_serialize_choice() {
    any_choice root;
    any_choice_leaf::moc moc(root);

    moc.push_back(std::string("test"), "value");
    aka2::any an;
    an.wc_.name_ = aka2::qname("test");
    moc.push_back(an, "&any");

    aka2::xml_serializer ser;
    std::ostringstream ostm;
    ser.serialize(root, "any_choice", ostm);

    //std::cout << ostm.rdbuf()->str() << std::endl;
  }

  void test_deserialize_choice() {
    any_choice root;
    any_choice_leaf::moc moc(root);

    moc.push_back(std::string("test"), "value");
    aka2::any an;
    an.wc_.name_ = aka2::qname("test");
    moc.push_back(an, "&any");

    aka2::xml_serializer ser;
    std::ostringstream ostm;
    ser.serialize(root, "any_choice", ostm);

    aka2::xml_deserializer deserializer;
    aka2::document doc = deserializer.deserialize(ostm.rdbuf()->str());

  }


  void test_serialize_array_choice() {
    any_array_choice root;
    any_array_choice_leaf::moc moc(root);

    aka2::any_array ar;
    aka2::any an;
    an.wc_.name_ = aka2::qname("any_array_item");
    ar.push_back(an);

    moc.push_back(ar, "&any");
    moc.push_back(std::string("test"), "value");

    aka2::xml_serializer ser;
    std::ostringstream ostm;
    ser.serialize(root, "any_array_choice", ostm);

    //std::cout << ostm.rdbuf()->str() << std::endl;
  }


  void test_deserialize_array_choice() {
    any_array_choice root;
    any_array_choice_leaf::moc moc(root);

    aka2::any_array ar;
    aka2::any an;
    an.wc_.name_ = aka2::qname("any_array_item");
    ar.push_back(an);

    moc.push_back(ar, "&any");
    moc.push_back(std::string("test"), "value");

    aka2::xml_serializer ser;
    std::ostringstream ostm;
    ser.serialize(root, "any_array_choice", ostm);

    //std::cout << ostm.rdbuf()->str() << std::endl;

    aka2::xml_deserializer deserializer;
    aka2::document doc = deserializer.deserialize(ostm.rdbuf()->str());
    //ser.serialize(doc, std::cout);

  }

  void test_anyType_choice() {
    const char *urdoc = 
      "<?xml version=\"1.0\"?>"
      "<anyType_choice_test>"
      "<value>ss</value>"
      "<any fake_attr=\"attr\">test1<ur_node>test</ur_node></any>"
      "<value>ss</value>"
      "<any_array fake_attr=\"attr\">test1<ur_node>test</ur_node></any_array>"
      "<any_array fake_attr=\"attr\">test1<ur_node>test</ur_node></any_array>"
      "<value>ss</value>"
      "<any_array fake_attr=\"attr\">test1<ur_node>test</ur_node></any_array>"
      "<any_array fake_attr=\"attr\">test1<ur_node>test</ur_node></any_array>"
      "</anyType_choice_test>";

    aka2::xml_deserializer deserializer;
    aka2::document doc = deserializer.deserialize(urdoc);

//     aka2::xml_serializer ser;
//     ser.serialize(doc, std::cout);
  }


//CUPPA:decl=-
};

//CUPPA:impl=+
//CUPPA:impl=-

CPPUNIT_TEST_SUITE_REGISTRATION(anyChoiceTest);
