/* -*- c++ -*- */
#ifndef AKAXISO2_XML_DESERIALIZER_DOCUMENT_HANDLER_H__
#define AKAXISO2_XML_DESERIALIZER_DOCUMENT_HANDLER_H__

/** @file akaxiso2/parser/document_handler.h */

#include <akaxiso2/framework/document.h>
#include <akaxiso2/framework/namespaces.h>

namespace aka2 {

  class locator;
  struct parser_context;
  typedef std::map<qname, std::string, qname_less> attribute_values;
  
  class document_handler {
  public:
    document_handler(entity_complements *ecomp);
    ~document_handler();

    void reset();

    void startElement(const qname &tagname, attribute_values& attrs);
    void characters(const char* chars, const unsigned int length);
    void endElement(const qname &tagname);
    void set_locator(const locator* const locator);
    void set_source_name(const std::string &source_name);

    document *adopt_document();
    const parser_context &get_context() const { return *context_; }

    entity_complements &get_entity_complements();

    void start_prefix_mapping(const std::string &prefix, const std::string &uri);
    void end_prefix_mapping(const std::string &prefix);

    document get_document() { return doc_; }

  protected:
    bool go_up(const qname& tagname);

  protected:
    std::string charsbuf_;
    shared_ptr<parser_context> context_;
    document doc_;
    int depth_;
  };

} // namespace aka2

#endif

