#include "schema_builtin_xiso.h"
#include "../framework/entity_complements.h"
#include "../framework/namespaces.h"
#include "../util/string_funcs.h"

namespace xs {

//   void QName_leaf::read_text(void *elm, aka2::isstream &istm, 
// 			    aka2::preconditions &pcd) {
//     aka2::qname &name = *static_cast<aka2::qname*>(elm);
//     std::string rawname;
//     istm >> rawname;
//     name.set(rawname, pcd.get_prefixes());
//   }

  void QName_leaf::read_text(void *elm, const std::string &entity, 
			     aka2::entity_complements &ecomp) {
    aka2::qname &name = *static_cast<aka2::qname*>(elm);
    std::string rawname = aka2::trim(entity);
    if (rawname.find_first_of(':') == std::string::npos)
      name.set(ecomp.get_prefixes().get_prefix_id(""), rawname); 
    else
      name.set(rawname, ecomp.get_prefixes()); 
  }


  void NCName_leaf::read_text(void *elm, const std::string &entity,
			      aka2::entity_complements &ecomp) {
    std::string value = aka2::trim(entity);
//     if (!is_NCName(value))
//       throw aka2::error("String, " + aka2::quote(value) + ", is not xs::NCName.",
// 			__FILE__, __LINE__);
    xs::NCName &ncname = *static_cast<xs::NCName*>(elm);
    ncname = value;
  }

  bool NCName_leaf::is_NCName(const std::string &value) {
    /* regexp "[\i-[:]][\c-[:]]*" !!!!!!*/

    if (value.empty())
      return false;
    if (!isalpha(value[0]) && (value[0] != '_'))
      return false;
    for (std::string::size_type pos = 1; pos < value.size(); ++pos) {
      std::string::value_type ch = value[pos];
      if (!isalnum(ch) && (ch != '.') && (ch != '_') && (ch != '-')) {
	return false;
      }
    }
    return true;
  }

  void ID_leaf::read_text(void *elm, const std::string &entity,
			  aka2::entity_complements &ecomp) {
    
    std::string value = aka2::trim(entity);

//     if (!NCName_leaf::is_NCName(value))
//       throw aka2::error("String, " + aka2::quote(value) + ", is not xs::NCName.",
// 			__FILE__, __LINE__);

    if (!ecomp.check_id(value)) {
      throw aka2::error("xs::ID, " + aka2::quote(value) + ", has already appeared.",
			__FILE__, __LINE__);
    }

    xs::ID &id = *static_cast<xs::ID*>(elm);
    id = value;
  }

}

