/* -*- c++ -*- */
#ifndef AKAXISO2_SCHEMA_SCHEMA_BUILTIN_XISO_H__
#define AKAXISO2_SCHEMA_SCHEMA_BUILTIN_XISO_H__

#include <akaxiso2/builtin/builtin_xiso.h>
#include <akaxiso2/builtin/schema_builtin.h>

#include <set>

namespace xs {
  
  struct QName_leaf : aka2::simpletype<QName, QName_leaf> {
    static void read_text(void *elm, const std::string &entity, 
			  aka2::entity_complements &ecomp);
  };
  
  struct NCName_leaf : aka2::simpletype<NCName, NCName_leaf> {
    static void read_text(void *elm, const std::string &entity, 
			  aka2::entity_complements &ecomp);
    static bool is_NCName(const std::string &value);
  };
  
  struct ID_leaf : aka2::simpletype<ID, ID_leaf> {
    static void read_text(void *elm, const std::string &entity, 
			  aka2::entity_complements &ecomp);
  };

  // Binary
  typedef xiso::leaf<base64Binary> base64Binary_leaf;
  typedef xiso::leaf<hexBinary> hexBinary_leaf;
  typedef xiso::leaf<string> string_leaf;
  typedef xiso::leaf<normalizedString> normalizedString_leaf;
  typedef xiso::leaf<token> token_leaf;
  typedef xiso::leaf<positiveInteger> positiveInteger_leaf;
  typedef xiso::leaf<negativeInteger> negativeInteger_leaf;
  typedef xiso::leaf<nonPositiveInteger> nonPositiveInteger_leaf;
  typedef xiso::leaf<nonNegativeInteger> nonNegativeInteger_leaf;
  typedef xiso::leaf<decimal> decimal_leaf;
  typedef xiso::leaf<time> time_leaf;
  typedef xiso::leaf<dateTime> dateTime_leaf;
  typedef xiso::leaf<duration> duration_leaf;
  typedef xiso::leaf<date> date_leaf;
  typedef xiso::leaf<gMonth> gMonth_leaf;
  typedef xiso::leaf<gYear> gYear_leaf;
  typedef xiso::leaf<gYearMonth> gYearMonth_leaf;
  typedef xiso::leaf<gDay> gDay_leaf;
  typedef xiso::leaf<gMonthDay> gMonthDay_leaf;
  typedef xiso::leaf<Name> Name_leaf;
  typedef xiso::leaf<anyURI> anyURI_leaf;
  typedef xiso::leaf<language> language_leaf;
  typedef xiso::leaf<IDREF> IDREF_leaf;
  typedef xiso::leaf<IDREFS> IDREFS_leaf;
  typedef xiso::leaf<ENTITY> ENTITY_leaf;
  typedef xiso::leaf<ENTITIES> ENTITIES_leaf;
  typedef xiso::leaf<NOTATION> NOTATION_leaf;
  typedef xiso::leaf<NMTOKEN> NMTOKEN_leaf;
  typedef xiso::leaf<NMTOKENS> NMTOKENS_leaf;

  typedef aka2::sequential_array<base64Binary_array> base64Binary_array_leaf;
  typedef aka2::sequential_array<hexBinary_array> hexBinary_array_leaf;

  typedef aka2::sequential_array<string_array> string_array_leaf;
  typedef aka2::sequential_array<normalizedString_array> normalizedString_array_leaf;
  typedef aka2::sequential_array<token_array> token_array_leaf;

  typedef aka2::sequential_array<positiveInteger_array> positiveInteger_array_leaf;
  typedef aka2::sequential_array<negativeInteger_array> negativeInteger_array_leaf;
  typedef aka2::sequential_array<nonPositiveInteger_array> nonPositiveInteger_array_leaf;
  typedef aka2::sequential_array<nonNegativeInteger_array> nonNegativeInteger_array_leaf;
  typedef aka2::sequential_array<decimal_array> decimal_array_leaf;

  typedef aka2::sequential_array<time_array> time_array_leaf;
  typedef aka2::sequential_array<dateTime_array> dateTime_array_leaf;
  typedef aka2::sequential_array<duration_array> duration_array_leaf;
  typedef aka2::sequential_array<date_array> date_array_leaf;
  typedef aka2::sequential_array<gMonth_array> gMonth_array_leaf;
  typedef aka2::sequential_array<gYear_array> gYear_array_leaf;
  typedef aka2::sequential_array<gYearMonth_array> gYearMonth_array_leaf;
  typedef aka2::sequential_array<gDay_array> gDay_array_leaf;
  typedef aka2::sequential_array<gMonthDay_array> gMonthDay_array_leaf;
  typedef aka2::sequential_array<Name_array> Name_array_leaf;
  typedef aka2::sequential_array<QName_array>  QName_array_leaf;
  typedef aka2::sequential_array<NCName_array> NCName_array_leaf;
  typedef aka2::sequential_array<anyURI_array> anyURI_array_leaf;
  typedef aka2::sequential_array<language_array> language_array_leaf;
  typedef aka2::sequential_array<ID_array, ID_leaf> ID_array_leaf;
  typedef aka2::sequential_array<IDREF_array> IDREF_array_leaf;
  typedef aka2::sequential_array<IDREFS_array> IDREFS_array_leaf;
  typedef aka2::sequential_array<ENTITY_array> ENTITY_array_leaf;
  typedef aka2::sequential_array<ENTITIES_array> ENTITIES_array_leaf;
  typedef aka2::sequential_array<NOTATION_array> NOTATION_array_leaf;
  typedef aka2::sequential_array<NMTOKEN_array> NMTOKEN_array_leaf;
  typedef aka2::sequential_array<NMTOKENS_array> NMTOKENS_array_leaf;

  
}

namespace xiso {
  template<>
  struct leaf<xs::QName> : xs::QName_leaf { };
}

#endif
