#include <akaxiso/akaxiso.h>
#include "element.h"
#include <iostream>

int main(int argc, char* argv[]){
  
  // Initialize Xerces.
  aka::initialize();
  // Initialize Document classes.
  instantiate_xiso();

  // deserialize
  aka::document doc;
  try {
    doc = aka::deserialize(std::cin);
  }
  catch (const aka::error &e) {
    std::cerr << e.what() << std::endl;
    std::cerr << "Parse error detected.  Abort immediately." << std::endl;
    exit(1);
  }
  catch ( ... ) {
    std::cerr << "Unhandled parse error detected.  Abort immediatedly." << std::endl;
    exit(1);
  }

  std::cerr << "Document root tag is " << doc.get_name() << "." << std::endl;
  /*
    Get the root node of document.
    YourDoc *ydoc = static_cast<YourDoc*>(doc->get_root());
  */

  aka::xml_serializer ser;
  ser.serialize(doc, std::cout);

  // Uninitializers.
  aka::uninitialize();

  return 0;
}
