/* -*- c++ -*- */
#ifndef XMLSchema_h__
#define XMLSchema_h__


#include <osixaka2/xml.h>

#include <osixaka2/osx.h>

#include <akaxiso2/builtin/builtin.h>
#include <akaxiso2/builtin/schema_builtin.h>
#include <osixaka2/schema_st.h>


namespace xs {

  /** simpleType definitions */

  typedef ::xs::allNNI all_maxOccurs;

  typedef std::list< ::xs::all_maxOccurs> all_maxOccurs_array;

  typedef ::xs::nonNegativeInteger all_minOccurs;

  typedef std::list< ::xs::all_minOccurs> all_minOccurs_array;

  typedef ::xs::NMTOKEN attribute_use;

  typedef std::list< ::xs::attribute_use> attribute_use_array;

  typedef ::std::string blockSet;

  typedef std::list< ::std::string> blockSet_array;

  typedef ::xs::NMTOKEN derivationControl;

  typedef std::list< ::xs::derivationControl> derivationControl_array;

  typedef ::std::string derivationSet;

  typedef std::list< ::std::string> derivationSet_array;

  typedef ::xs::token field_xpath;

  typedef std::list< ::xs::field_xpath> field_xpath_array;

  typedef ::xs::NMTOKEN formChoice;

  typedef std::list< ::xs::formChoice> formChoice_array;

  typedef ::std::string fullDerivationSet;

  typedef std::list< ::std::string> fullDerivationSet_array;

  typedef ::std::string namespaceList;

  typedef std::list< ::std::string> namespaceList_array;

  typedef ::xs::allNNI narrowMaxMin_maxOccurs;

  typedef std::list< ::xs::narrowMaxMin_maxOccurs> narrowMaxMin_maxOccurs_array;

  typedef ::xs::nonNegativeInteger narrowMaxMin_minOccurs;

  typedef std::list< ::xs::narrowMaxMin_minOccurs> narrowMaxMin_minOccurs_array;

  typedef ::xs::token _public;

  typedef std::list< ::xs::_public> public_array;

  typedef ::xs::derivationControl reducedDerivationControl;

  typedef std::list< ::xs::reducedDerivationControl> reducedDerivationControl_array;

  typedef ::xs::token selector_xpath;

  typedef std::list< ::xs::selector_xpath> selector_xpath_array;

  typedef ::std::string simpleDerivationSet;

  typedef std::list< ::std::string> simpleDerivationSet_array;

  typedef ::xs::derivationControl typeDerivationControl;

  typedef std::list< ::xs::typeDerivationControl> typeDerivationControl_array;

  typedef ::std::string union_memberTypes;

  typedef std::list< ::std::string> union_memberTypes_array;

  typedef ::xs::NMTOKEN whiteSpace_value;

  typedef std::list< ::xs::whiteSpace_value> whiteSpace_value_array;

  typedef ::xs::NMTOKEN wildcard_processContents;

  typedef std::list< ::xs::wildcard_processContents> wildcard_processContents_array;

  /** complexType definitions */

  struct appinfo {
    /** members */
    ::aka::any_array any_;
    /** attributes */
    ::xs::anyURI source_;
    aka::wc_attributes attributes_;
  };

  struct documentation {
    /** members */
    ::aka::any_array any_;
    /** attributes */
    ::xs::anyURI source_;
    ::xs::language xml_lang_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> annotation_choice;

  struct annotation {
    /** members */
    ::xs::annotation_choice c0_;
    /** attributes */
    ::xs::ID id_;
    aka::wc_attributes attributes_;
  };

  struct annotated {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::annotated> annotated_array;

  struct anyType {
    /** members */
    ::aka::any_array any_;
    /** attributes */
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::anyType> anyType_array;

  struct attributeGroupRef {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::xs::QName ref_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::attributeGroupRef> attributeGroupRef_array;

  struct groupRef {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::xs::QName ref_;
    ::xs::nonNegativeInteger minOccurs_;
    ::xs::allNNI maxOccurs_;
    aka::wc_attributes attributes_;
  };

  struct facet {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::std::string value_;
    bool fixed_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::facet> facet_array;

  typedef std::list< ::xs::groupRef> groupRef_array;

  struct selector {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::xs::selector_xpath xpath_;
    aka::wc_attributes attributes_;
  };

  struct field {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::xs::field_xpath xpath_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::field> field_array;

  struct keybase {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::selector selector_;
    ::xs::field_array field_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::keybase> keybase_array;

  struct noFixedFacet {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::std::string value_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::noFixedFacet> noFixedFacet_array;

  struct numFacet {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::std::string value_;
    bool fixed_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::numFacet> numFacet_array;

  struct openAttrs {
    /** attributes */
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::openAttrs> openAttrs_array;

  struct wildcard {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::std::string namespace_;
    ::xs::wildcard_processContents processContents_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::wildcard> wildcard_array;

  struct totalDigits {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::std::string value_;
    bool fixed_;
    aka::wc_attributes attributes_;
  };

  struct whiteSpace {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::std::string value_;
    bool fixed_;
    aka::wc_attributes attributes_;
  };

  struct pattern {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::std::string value_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> facets;

  typedef std::list< ::xs::facets> facets_array;

  struct keyref {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::selector selector_;
    ::xs::field_array field_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::QName refer_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> identityConstraint;

  typedef std::list< ::xs::identityConstraint> identityConstraint_array;

  struct any {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::std::string namespace_;
    ::xs::wildcard_processContents processContents_;
    ::xs::nonNegativeInteger minOccurs_;
    ::xs::allNNI maxOccurs_;
    aka::wc_attributes attributes_;
  };

  struct import {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::xs::anyURI namespace_;
    ::xs::anyURI schemaLocation_;
    aka::wc_attributes attributes_;
  };

  struct include {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::xs::anyURI schemaLocation_;
    aka::wc_attributes attributes_;
  };

  struct notation {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::_public public_;
    ::xs::anyURI system_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> directives;

  typedef std::list<aka::item> schemaTop;

  typedef std::list< ::xs::annotation> annotation_array;

  struct schemaTops_item {
    /** members */
    ::xs::schemaTop schemaTop_;
    ::xs::annotation_array annotation_;
  };

  typedef std::list< ::xs::schemaTops_item> schemaTops;

  typedef std::list< ::xs::schemaTop> schemaTop_array;

  struct schema {
    /** members */
    ::xs::directives directives_;
    ::xs::schemaTops schemaTops_;
    /** attributes */
    ::xs::anyURI targetNamespace_;
    ::xs::token version_;
    ::std::string finalDefault_;
    ::std::string blockDefault_;
    ::xs::formChoice attributeFormDefault_;
    ::xs::formChoice elementFormDefault_;
    ::xs::ID id_;
    ::xs::language xml_lang_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> redefine_choice;

  struct redefine {
    /** members */
    ::xs::redefine_choice c0_;
    /** attributes */
    ::xs::anyURI schemaLocation_;
    ::xs::ID id_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> complexContent_choice;

  struct complexContent {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::complexContent_choice c0_;
    /** attributes */
    ::xs::ID id_;
    bool mixed_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> topLevelElement_sequence_c0;

  struct topLevelElement {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::topLevelElement_sequence_c0 c0_;
    ::xs::identityConstraint identityConstraint_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::QName type_;
    ::xs::QName substitutionGroup_;
    ::std::string default_;
    ::std::string fixed_;
    bool nillable_;
    bool abstract_;
    ::std::string final_;
    ::std::string block_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::topLevelElement> topLevelElement_array;

  typedef std::list<aka::item> restrictionType_sequence_c0;

  typedef std::list<aka::item> realGroup_sequence_c0;

  struct realGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::realGroup_sequence_c0 c0_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::QName ref_;
    ::xs::nonNegativeInteger minOccurs_;
    ::xs::allNNI maxOccurs_;
    ::xs::token osx_classname_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::realGroup> realGroup_array;

  typedef std::list<aka::item> namedGroup_sequence_c0;

  struct namedGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::namedGroup_sequence_c0 c0_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::token osx_classname_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::namedGroup> namedGroup_array;

  typedef std::list<aka::item> localElement_sequence_c0;

  struct localElement {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::localElement_sequence_c0 c0_;
    ::xs::identityConstraint identityConstraint_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::QName ref_;
    ::xs::QName type_;
    ::xs::nonNegativeInteger minOccurs_;
    ::xs::allNNI maxOccurs_;
    ::std::string default_;
    ::std::string fixed_;
    bool nillable_;
    ::std::string block_;
    ::xs::formChoice form_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::localElement> localElement_array;

  typedef std::list<aka::item> element_sequence_c0;

  struct element {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::element_sequence_c0 c0_;
    ::xs::identityConstraint identityConstraint_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::QName ref_;
    ::xs::QName type_;
    ::xs::QName substitutionGroup_;
    ::xs::nonNegativeInteger minOccurs_;
    ::xs::allNNI maxOccurs_;
    ::std::string default_;
    ::std::string fixed_;
    bool nillable_;
    bool abstract_;
    ::std::string final_;
    ::std::string block_;
    ::xs::formChoice form_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::element> element_array;

  typedef std::list<aka::item> simpleContent_choice;

  struct simpleContent {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::simpleContent_choice c0_;
    /** attributes */
    ::xs::ID id_;
    aka::wc_attributes attributes_;
  };

  typedef std::list<aka::item> typeDefParticle;

  typedef std::list<aka::item> attrDecls_c0;

  struct attrDecls {
    /** members */
    ::xs::attrDecls_c0 c0_;
    aka::deep_ptr< ::xs::wildcard> anyAttribute_;
  };

  struct complexTypeModelParticle {
    /** members */
    ::xs::typeDefParticle typeDefParticle_;
    ::xs::attrDecls attrDecls_;
  };

  struct attributeGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::QName ref_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::attributeGroup> attributeGroup_array;

  struct complexRestrictionType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::typeDefParticle typeDefParticle_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::xs::ID id_;
    ::xs::QName base_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::complexRestrictionType> complexRestrictionType_array;

  typedef std::list<aka::item> complexTypeModel;

  struct complexType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::complexTypeModel complexTypeModel_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    bool mixed_;
    ::xs::token osx_classname_;
    bool abstract_;
    ::std::string final_;
    ::std::string block_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::complexType> complexType_array;

  struct extensionType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::typeDefParticle typeDefParticle_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::xs::ID id_;
    ::xs::QName base_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::extensionType> extensionType_array;

  struct localComplexType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::complexTypeModel complexTypeModel_;
    /** attributes */
    ::xs::ID id_;
    bool mixed_;
    ::xs::token osx_classname_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::localComplexType> localComplexType_array;

  struct namedAttributeGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::namedAttributeGroup> namedAttributeGroup_array;

  struct restrictionType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::restrictionType_sequence_c0 c0_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::xs::ID id_;
    ::xs::QName base_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::restrictionType> restrictionType_array;

  struct simpleExtensionType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::xs::ID id_;
    ::xs::QName base_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::simpleExtensionType> simpleExtensionType_array;

  struct topLevelComplexType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::complexTypeModel complexTypeModel_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    bool mixed_;
    ::xs::token osx_classname_;
    bool abstract_;
    ::std::string final_;
    ::std::string block_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::topLevelComplexType> topLevelComplexType_array;

  typedef std::list< ::xs::attrDecls> attrDecls_array;

  typedef std::list< ::xs::complexTypeModel> complexTypeModel_array;

  typedef std::list< ::xs::typeDefParticle> typeDefParticle_array;

  typedef std::list<aka::item> narrowMaxMin_sequence_c0;

  struct narrowMaxMin {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::narrowMaxMin_sequence_c0 c0_;
    ::xs::identityConstraint identityConstraint_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::QName ref_;
    ::xs::QName type_;
    ::xs::nonNegativeInteger minOccurs_;
    ::xs::allNNI maxOccurs_;
    ::std::string default_;
    ::std::string fixed_;
    bool nillable_;
    ::std::string block_;
    ::xs::formChoice form_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::narrowMaxMin> narrowMaxMin_array;

  struct allModel {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::narrowMaxMin_array element_;
  };

  struct namedGroup_sequence_c0_all {
    /** members */
    ::xs::allModel allModel_;
    /** attributes */
    ::xs::ID id_;
    ::xs::token osx_classname_;
    aka::wc_attributes attributes_;
  };

  struct all {
    /** members */
    ::xs::allModel allModel_;
    /** attributes */
    ::xs::ID id_;
    ::xs::nonNegativeInteger minOccurs_;
    ::xs::allNNI maxOccurs_;
    ::xs::token osx_classname_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::all> all_array;

  typedef std::list< ::xs::allModel> allModel_array;

  /** forwareded declaration for ptrmember value class. */
  struct localSimpleType;
  struct attribute {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    aka::deep_ptr< ::xs::localSimpleType> simpleType_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::QName ref_;
    ::xs::QName type_;
    ::xs::attribute_use use_;
    ::std::string default_;
    ::std::string fixed_;
    ::xs::formChoice form_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::attribute> attribute_array;

  typedef std::list<aka::item> nestedParticle;

  struct explicitGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::nestedParticle nestedParticle_;
    /** attributes */
    ::xs::ID id_;
    ::xs::nonNegativeInteger minOccurs_;
    ::xs::allNNI maxOccurs_;
    ::xs::token osx_classname_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::explicitGroup> explicitGroup_array;

  typedef std::list<aka::item> particle;

  struct group {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::particle particle_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::QName ref_;
    ::xs::nonNegativeInteger minOccurs_;
    ::xs::allNNI maxOccurs_;
    ::xs::token osx_classname_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::group> group_array;

  struct simpleExplicitGroup {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::nestedParticle nestedParticle_;
    /** attributes */
    ::xs::ID id_;
    ::xs::token osx_classname_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::simpleExplicitGroup> simpleExplicitGroup_array;

  typedef std::list< ::xs::nestedParticle> nestedParticle_array;

  typedef std::list< ::xs::particle> particle_array;

  typedef std::list<aka::item> simpleDerivation;

  struct localSimpleType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::simpleDerivation simpleDerivation_;
    /** attributes */
    ::xs::ID id_;
    ::xs::token osx_leaf_;
    ::xs::token osx_typedef_;
    ::xs::QName osx_resolve_;
    ::xs::token osx_classname_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::localSimpleType> localSimpleType_array;

  struct simpleRestrictionModel {
    /** members */
    aka::deep_ptr< ::xs::localSimpleType> simpleType_;
    ::xs::facets facets_;
  };

  struct simpleRestrictionType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    aka::deep_ptr< ::xs::simpleRestrictionModel> simpleRestrictionModel_;
    ::xs::attrDecls attrDecls_;
    /** attributes */
    ::xs::ID id_;
    ::xs::QName base_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::simpleRestrictionType> simpleRestrictionType_array;

  struct simpleType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::simpleDerivation simpleDerivation_;
    /** attributes */
    ::xs::ID id_;
    ::std::string final_;
    ::xs::NCName name_;
    ::xs::token osx_leaf_;
    ::xs::token osx_typedef_;
    ::xs::QName osx_resolve_;
    ::xs::token osx_classname_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::simpleType> simpleType_array;

  struct topLevelAttribute {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    aka::deep_ptr< ::xs::localSimpleType> simpleType_;
    /** attributes */
    ::xs::ID id_;
    ::xs::NCName name_;
    ::xs::QName type_;
    ::std::string default_;
    ::std::string fixed_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::topLevelAttribute> topLevelAttribute_array;

  struct topLevelSimpleType {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::simpleDerivation simpleDerivation_;
    /** attributes */
    ::xs::ID id_;
    ::std::string final_;
    ::xs::NCName name_;
    ::xs::token osx_leaf_;
    ::xs::token osx_typedef_;
    ::xs::QName osx_resolve_;
    ::xs::token osx_classname_;
    aka::wc_attributes attributes_;
  };

  typedef std::list< ::xs::topLevelSimpleType> topLevelSimpleType_array;

  typedef std::list<aka::item> redefinable;

  typedef std::list< ::xs::redefinable> redefinable_array;

  typedef std::list< ::xs::simpleDerivation> simpleDerivation_array;

  typedef std::list< ::xs::simpleRestrictionModel> simpleRestrictionModel_array;

  struct list {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    aka::deep_ptr< ::xs::localSimpleType> simpleType_;
    /** attributes */
    ::xs::ID id_;
    ::xs::QName itemType_;
    aka::wc_attributes attributes_;
  };

  struct restriction {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::simpleRestrictionModel simpleRestrictionModel_;
    /** attributes */
    ::xs::ID id_;
    ::xs::QName base_;
    aka::wc_attributes attributes_;
  };

  struct _union {
    /** members */
    aka::deep_ptr< ::xs::annotation> annotation_;
    ::xs::localSimpleType_array simpleType_;
    /** attributes */
    ::xs::ID id_;
    ::std::string memberTypes_;
    aka::wc_attributes attributes_;
  };


}

#endif // #ifndef XMLSchema_h__
