/* -*- c++ -*- */
#ifndef OSIXAKA2_EXCEPTION_H__
#define OSIXAKA2_EXCEPTION_H__

#include <akaxiso2/util/sstream.h>
#include <akaxiso2/akaxiso2.h>

namespace osx {

  class internal_error : public aka::error {
  public:
    internal_error(const char *file, const unsigned long line) :
      aka::error("Internal error.", __FILE__, __LINE__) { }
  };

  class not_supported : public aka::error {
  public:
    not_supported(const char *file, const unsigned long line) :
      aka::error("Not supported.",file, line) { }
  };

  class not_implemented : public aka::error {
  public:
    not_implemented(const char *file, const unsigned long line) :
      aka::error("Not implemented.",file, line) { }
  };

  void raise_name_error(const std::string &caption,
			const aka::qname &type, 
			const std::string &message,
			const char *file, const unsigned long line);
}

#endif
