#include <osixaka2/osx_xiso.h>

#include <akaxiso2/akaxiso2.h>


namespace osx {

  void array_type_leaf::model() {
    /** attribute member definition. */
    attribute("container", &::osx::array_type::container_, xiso::leaf< ::std::string>()).required(true);
    attribute("prefix", &::osx::array_type::prefix_, xiso::leaf< ::std::string>()).required(true);
    attribute("suffix", &::osx::array_type::suffix_, xiso::leaf< ::std::string>()).required(true);
  }

  void primitive_leaf::model() {
    /** element member definitions */
    ptrmember("osx:typedef", &::osx::primitive::typedef_, xiso::leaf< ::xs::token>());
    ptrmember("osx:leaf", &::osx::primitive::leaf_, xiso::leaf< ::xs::token>());
  }

  void builtin_array_leaf::model() {
    /** element member definitions */
    member("&primitive", &::osx::builtin_array::primitive_, ::osx::primitive_leaf());
    /** attribute member definition. */
    attribute("name", &::osx::builtin_array::name_, xiso::leaf< ::std::string>()).required(true);
  }

  void type_leaf::model() {
    /** element member definitions */
    member("&primitive", &::osx::type::primitive_, ::osx::primitive_leaf());
    ptrmember("osx:array", &::osx::type::array_, ::osx::builtin_array_leaf());
    /** attribute member definition. */
    attribute("name", &::osx::type::name_, xiso::leaf< ::std::string>()).required(true);
  }

  void builtins_leaf::model() {
    /** element member definitions */
    member("osx:type", &::osx::builtins::type_, ::osx::type_array_leaf(), 0, aka::unbounded);
  }

  void container_type_leaf::model() {
    /** attribute member definition. */
    attribute("container", &::osx::container_type::container_, xiso::leaf< ::std::string>()).required(true);
  }

  void include_leaf::model() {
    value(&::osx::include::value_);
    /** attribute member definition. */
    attribute("system", &::osx::include::system_, xiso::leaf< bool>()).set_default("false");
  }

  void namespace_leaf::model() {
    /** attribute member definition. */
    attribute("prefix", &::osx::_namespace::prefix_, xiso::leaf< ::std::string>()).required(true);
    attribute("uri", &::osx::_namespace::uri_, xiso::leaf< ::xs::anyURI>());
  }

  void directives_choice_leaf::model() {
    /** occurrence used when choice is a root element. */
    occurrence(0, aka::unbounded);
    /** element member definitions */
    item("osx:include", ::osx::include_leaf());
    item("osx:xiso_include", ::osx::include_leaf());
    item("osx:ximpl_include", ::osx::include_leaf());
    item("osx:namespace", ::osx::namespace_leaf());
  }

  void directives_leaf::model() {
    /** element member definitions */
    member("&c0", &::osx::directives::c0_, ::osx::directives_choice_leaf(), 0, aka::unbounded);
  }

  void escape_leaf::model() {
    /** attribute member definition. */
    attribute("to_escape", &::osx::escape::to_escape_, xiso::leaf< ::std::string>()).required(true);
    attribute("escaped", &::osx::escape::escaped_, xiso::leaf< ::std::string>()).required(true);
  }

  void escapes_leaf::model() {
    /** element member definitions */
    member("osx:escape", &::osx::escapes::escape_, ::osx::escape_array_leaf(), 0, aka::unbounded);
  }

  void member_type_leaf::model() {
    /** attribute member definition. */
    attribute("prefix", &::osx::member_type::prefix_, xiso::leaf< ::std::string>()).required(true);
    attribute("suffix", &::osx::member_type::suffix_, xiso::leaf< ::std::string>()).required(true);
  }

  void simplecontent_value_name_leaf::model() {
    /** attribute member definition. */
    attribute("valuename", &::osx::simplecontent_value_name::valuename_, xiso::leaf< ::std::string>()).required(true);
  }

  void format_leaf::model() {
    /** element member definitions */
    member("osx:member", &::osx::format::member_, ::osx::member_type_leaf());
    member("osx:array", &::osx::format::array_, ::osx::array_type_leaf());
    member("osx:choice", &::osx::format::choice_, ::osx::container_type_leaf());
    member("osx:simplecontent", &::osx::format::simplecontent_, ::osx::simplecontent_value_name_leaf());
    member("osx:particle_item", &::osx::format::particle_item_, ::osx::member_type_leaf());
  }

  void resolve_leaf::model() {
    value(&::osx::resolve::value_);
    /** attribute member definition. */
    attribute("name", &::osx::resolve::name_, xiso::leaf< ::std::string>()).required(true);
  }

  void imports_choice_leaf::model() {
    /** occurrence used when choice is a root element. */
    occurrence(0, aka::unbounded);
    /** element member definitions */
    item("osx:resolve", ::osx::resolve_leaf());
    item("osx:type", ::osx::type_leaf());
  }

  void imports_leaf::model() {
    /** element member definitions */
    member("&c0", &::osx::imports::c0_, ::osx::imports_choice_leaf(), 0, aka::unbounded);
  }

  void internal_leaf::model() {
    /** element member definitions */
    member("osx:builtins", &::osx::internal::builtins_, ::osx::builtins_leaf());
    member("osx:imports", &::osx::internal::imports_, ::osx::imports_leaf());
  }

  void substitution_leaf::model() {
    /** attribute member definition. */
    attribute("original", &::osx::substitution::original_, xiso::leaf< ::std::string>()).required(true);
    attribute("substituted", &::osx::substitution::substituted_, xiso::leaf< ::std::string>()).required(true);
  }

  void substitutions_leaf::model() {
    /** element member definitions */
    member("osx:substitution", &::osx::substitutions::substitution_, ::osx::substitution_array_leaf(), 0, aka::unbounded);
  }

  void preference_leaf::model() {
    /** element member definitions */
    member("osx:format", &::osx::preference::format_, ::osx::format_leaf());
    member("osx:substitutions", &::osx::preference::substitutions_, ::osx::substitutions_leaf());
    member("osx:escapes", &::osx::preference::escapes_, ::osx::escapes_leaf());
    member("osx:directives", &::osx::preference::directives_, ::osx::directives_leaf());
    ptrmember("osx:internal", &::osx::preference::internal_, ::osx::internal_leaf());
  }


}

