#include <akaxiso2/configuration.h>
#include <string>
#include <vector>
#include <algorithm> // {VC6}

#include "util.h"

#ifdef _WIN32
  const char to_replace = '/';
  const char replaced = '\\';
#else
  const char to_replace = '\\';
  const char replaced = '/';
#endif

std::string osx::replace_path_seperator(const std::string &path) {
  std::string ret(path);
  for (std::string::size_type i = 0; i < path.size(); ++i)
    if (ret[i] == to_replace)
      ret[i] = replaced;
  return ret;
}
  

std::string osx::get_dirpath(const std::string &path) {
  std::string::size_type pos = path.find_last_of("/\\");
  if (pos == std::string::npos) { // not found!
    return replace_path_seperator("./");
  }      
  else {
    return replace_path_seperator(path.substr(0, pos + 1));
  }
}

std::string osx::get_filename(const std::string &path) {
  std::string::size_type pos = path.find_last_of("/\\");
  if (pos == std::string::npos) // path seperator not found.
    return path;
  else
    return path.substr(pos + 1);
}

std::string osx::get_basename(const std::string &path) {
  std::string filename = get_filename(path);

  std::string::size_type pos = filename.find_last_of('.');
  if (pos == std::string::npos)
    return filename;
  else
    return filename.substr(0, pos);
}

namespace {
  typedef std::vector<std::string> path_tokens;
  
  bool remove_period(path_tokens &tokens) {
    // remove "./"
    std::vector<std::string>::iterator it = 
      std::find(tokens.begin(), tokens.end(), ".");
    if (it == tokens.end())
      return false;
    tokens.erase(it);
    return true;
  }


  bool remove_double_period(path_tokens &tokens) {
    // convert "path/../" -> "././"
    if (tokens.size() <= 1)
      return false;
    std::vector<std::string>::iterator bit = tokens.begin();
    ++bit;
    std::vector<std::string>::iterator it = 
      std::find(bit, tokens.end(), "..");
    if (it == tokens.end())
      return false;
    *it = ".";
    --it; *it = ".";
    while (remove_period(tokens));
    return true;
  }
}

std::string osx::simplify_path(const std::string &path) {
  std::string::size_type index = 0, curpos = 0;
  path_tokens tokens;

  while (true) {
    index = path.find_first_of("/\\", index);
    if (index == std::string::npos) {
      tokens.push_back(path.substr(curpos, path.size() - curpos));
      break;
    }
    else {
      tokens.push_back(path.substr(curpos, index - curpos));
      ++index;
      curpos = index;
    }
  }

  while (remove_period(tokens));
  while (remove_double_period(tokens));

  std::string simplified;
  for (path_tokens::size_type token_index = 0; 
       token_index < tokens.size() - 1; ++token_index) {
    simplified += tokens[token_index] + "/";
  }
  simplified += tokens[tokens.size() - 1];

  return simplified;
}
