#include "document_handler.h"

#include "../../util/string_funcs.h"
#include "../../framework/qname.h"
#include "../../framework/document.h"
#include "../../framework/document_factory.h"
#include "sequence_handler.h"
#include "choice_handler.h"
#include "all_handler.h"
#include "simplecontent_handler.h"
#include "array_handler.h"
#include "simpletype_handler.h"
#include "handler.h"

using namespace aka2;

document_handler::document_handler(entity_complements *ecomp) : depth_(0) {
  context_ = shared_ptr<parser_context>(new parser_context(ecomp));
}

document_handler::~document_handler() {
}

void document_handler::reset() {
  context_->reset();
}

void document_handler::set_source_name(const std::string &source_name) {
  context_->set_source_name(source_name);
}

entity_complements & document_handler::get_entity_complements() {
  return context_->get_entity_complements();
} 


void document_handler::startElement(const qname &tagname , attribute_values& attrs) {

  ++depth_;
  context_->push_tagname(tagname);

  if (context_->empty()) {
    assert(depth_ == 1);
    charsbuf_.resize(0);
    doc_ = system_document_factory().create_named_document(tagname);
    node root = doc_.get_root();
    const element_op &op = doc_.get_op();
    handler *h = 0;

    switch (op.get_schematype()) {
    case sequence_id:
    case choice_id: 
    case all_id:
    case simplecontent_id:
    case simpletype_id:
    case fixed_id: 
    case wildcard_id: {
      h = handler::create_handler(doc_.get_props().is_emptiable(), 
				  root.ptr(), op, 1, tagname, doc_.get_props(), *context_);
      break;
    }
    case array_id: 
    case any_id:
    case ptrmember_id:
    case enclose_id:
    case disclose_id:
    case any_array_id:
    case wildcard_attribute_id:
      assert(!"Must not reach here.");
    }

    h->parse_attributes(root.ptr(), op, attrs);
    return;
  }

  while ((depth_ - 1) <= context_->top()->get_depth()) {
      
    context_->top()->parse_entity(charsbuf_);
    charsbuf_.resize(0);

    handler_ptr currenthandler = context_->top();
    
    validation_result res = currenthandler->query_element(tagname, attrs);
    if (res == ok) {
      node mpair = context_->top()->get_node();
      currenthandler->parse_attributes(mpair.ptr(), mpair.op(), attrs);
      return;
    }

    if (res == invalid)
      context_->report("Validation error found.", __FILE__, __LINE__);

    assert(res == skip);

    if (!go_up(tagname))
      break;

    if (context_->empty())
      break;
  }
  context_->report_no_element(tagname, __FILE__, __LINE__);
}


void document_handler::endElement(const qname &tagname){
  assert(depth_ > 0);
  --depth_;

  assert(!context_->empty());
  handler_ptr handler = context_->top();
  bool res = handler->parse_entity(charsbuf_); 
  if (!res)
    context_->report("Failed to parse entity.", __FILE__, __LINE__);
  
  while (depth_ != context_->top()->get_depth()) {
    assert(depth_ < context_->top()->get_depth());
    if (!go_up(tagname)) {
      context_->report_end_element_failure(tagname, __FILE__, __LINE__);
    }
    if (context_->empty())
      break;
  }
  context_->pop_tagname();
  charsbuf_.resize(0);
}

bool document_handler::go_up(const qname &tagname) {

  handler_ptr h = context_->top();
  context_->pop();

  validation_result res = h->end_element(tagname);
  if (res == invalid)
    h->abort();
  else if (!context_->empty()) // skip or ok.
    context_->top()->receive_child(h->get_node());
  return res != invalid;
}


void document_handler::characters(const   char*     chars, 
				  const unsigned int    length){
  charsbuf_ += std::string(chars, length);
}


void document_handler::set_locator(const locator* locator) {
  context_->set_locator(locator);
}

void document_handler::start_prefix_mapping(const std::string &prefix, const std::string &uri) {
  context_->get_entity_complements().get_prefixes().assign_prefix(prefix, uri);
}

void document_handler::end_prefix_mapping(const std::string &prefix) {
  context_->get_entity_complements().get_prefixes().clear_prefix(prefix);
}

