#include "sax2_adaptor.h"
#include "../../framework/document.h"
#include "../../framework/namespace_statics.h"
#include "document_handler.h"
#include "../../util/string_funcs.h"

using namespace aka2;

#ifdef _MSC_VER
#include <malloc.h>
#endif


qname sax2_adaptor::create_qname(const std::string &tagname) {
  assert(!tagname.empty());
  std::string trimmed = trim(tagname);
  qname name;
  if (trimmed.find_first_of(':') == std::string::npos) {
    name.set(ns_.get_current_decls().default_ns_id_, trimmed);
  }
  else {
    name.set(trimmed, *pfs_);
    if (name.get_namespace_id() == ns_.get_current_decls().default_ns_id_) {
      throw positioned_error("Prefixed tagname " + tag(tagname) 
			     + " found though namespace defaulting is applied.",
			     __FILE__, __LINE__);
    }
  }
  return name;
}



void ns_stack::inc_depth() {
  ns_decls decls;
  if (!stack_.empty())
    decls.default_ns_id_ = stack_.top().default_ns_id_;
  stack_.push(decls);
}

void ns_stack::dec_depth() {
  stack_.pop();
}

const ns_decls &ns_stack::get_current_decls() const {
  return stack_.top();
}

void ns_stack::set_default_ns_id(id_type id) {
  stack_.top().default_ns_id_ = id; 
}


bool ns_stack::process_namespace_attribute(const sax_attribute &attr, const nsdecl **decl) {

  std::string attrname = trim(attr.name_);
  if (attrname.find("xmlns", 0, 5) != 0) // is case sensitive? !!!!!!!!!!!!!!!
    return false;

  std::string uri = attr.value_.c_str();
  if ((uri.at(0) == '"') && (uri.at(uri.size() - 1) == '"')){
    uri.erase(0, 1);                // remove ""
    uri.erase(uri.length() - 1, 1);
  }

  nsdecl newentry;
  newentry.uri_ = uri;
  if (attrname.size() == 5) { // length of "xmlns"
    newentry.prefix_ = "";
  }
  else if (attrname.find("xmlns:", 0, 6) == 0) {
    newentry.prefix_ = attrname.substr(6); // check space included? !!!!!
    if (newentry.prefix_.empty()) {
      std::string message = "xmlns:=" + quote(uri) + ":namespace prefix is not specified.";
      throw error(message, __FILE__, __LINE__);
    }
  }

  stack_.top().prefixes_.push_back(newentry);
  *decl = &stack_.top().prefixes_.back();
  return true;

}


sax2_adaptor::sax2_adaptor() : handler_(0) { }


void sax2_adaptor::process_attributes(const sax_attributes &saxattrs, attribute_values &xattrs) {

  std::vector<size_t> non_ns_attrs;
  size_t i;

  for (i = 0; i < saxattrs.size(); ++i) {
    const nsdecl *decl = 0; 
    const sax_attribute &attr = saxattrs[i];
    if (ns_.process_namespace_attribute(attr, &decl)) {
      if (decl != 0)
	handler_->start_prefix_mapping(decl->prefix_, decl->uri_);
      if (decl->prefix_.empty()) // prefix is "", set default namespace id.
	ns_.set_default_ns_id(get_namespace_id(decl->uri_));
    }
    else {
      non_ns_attrs.push_back(i);
    }
  }
  
  for (i = 0; i < non_ns_attrs.size(); ++i) {
    const sax_attribute &attr = saxattrs[non_ns_attrs[i]];
    qname name;
    name.set(trim(attr.name_), *pfs_);  
    std::pair<attribute_values::iterator, bool> res = 
      xattrs.insert(attribute_values::value_type(name, attr.value_));
    if (!res.second){
      throw tagged_error("attribute", name.qualified(), "appeared more than twice.",
			 __FILE__, __LINE__);
    }
  }
}


void sax2_adaptor::startElement(const std::string &tagname, sax_attributes &saxattrs) {

  attribute_values xattrs;
  ns_.inc_depth();

  process_attributes(saxattrs, xattrs);
  qname name = create_qname(tagname);
  handler_->startElement(name, xattrs);
}


void sax2_adaptor::characters(const char *chars, const unsigned int length) {
  handler_->characters(chars, length);
}


void sax2_adaptor::endElement(const std::string &tagname) {

  handler_->endElement(create_qname(tagname));

  const ns_decls &nsdecls = ns_.get_current_decls();
  const ns_decls::prefixes &prfs = nsdecls.prefixes_;
  for (ns_decls::prefixes::const_iterator it = prfs.begin(); it != prfs.end(); ++it)
    handler_->end_prefix_mapping(it->prefix_);

  ns_.dec_depth();
}

void sax2_adaptor::set_handler(document_handler &handler) {
  handler_ = &handler;
  pfs_ = &handler.get_entity_complements().get_prefixes();
}

