/* -*- c++ -*- */
#ifndef AKAXISO2_XML_DESERIALIZER_SEQUENCE_HANDLER_H__
#define AKAXISO2_XML_DESERIALIZER_SEQUENCE_HANDLER_H__

/** @file akaxiso2/parser/seqquence_handler.h */

#include <akaxiso2/framework/member_cache.h>
#include <akaxiso2/XML/deserializer/handler.h>

namespace aka2 {

  class sequence_handler : public handler {
    friend class closure_handler;
  public:
    sequence_handler(bool emptiable, void *seq, const sequence_op &sop,
		     int depth,
		     const element_props &props, 
		     parser_context &context);
    sequence_handler(bool emptiable, int depth, sequence_handler *seqhandler, 
		     const element_props &props);

    virtual ~sequence_handler(){}
    virtual validation_result query_element(const qname &tagname, const attribute_values &attrs);
    virtual validation_result end_element(const qname &tagname);
    virtual validation_result query_next(const qname &tagname, const attribute_values &attrs);
    virtual bool parse_entity(const std::string &entity);

    virtual node get_node();
    virtual void receive_child(const node &child);
    virtual bool can_skip();
    virtual void abort();
    
  private:
    validation_result parse_element(const qname &tagname, const attribute_values &attrs,
				    member_types::const_iterator &it);
    validation_result find_particle(const qname &tagname, const attribute_values &attrs,
				    member_types::const_iterator &it,
				    bool &emptiable);
   
    bool can_skip_member();

    void report_end_sequence_failure(const qname &tagname, 
				     const char *filename, 
				     const unsigned long linenum);
    
    void *seq_;
    const sequence_op &sop_;
    member_types::const_iterator itend_;
    member_types::const_iterator current_;
    member_cache cache_;
  };

} // namespace aka2

#endif
