#include <iostream>
#include "../../configuration.h"

#ifdef AKAXISO2_USE_XERCESC

#include "istream_inputsource.h"
#include <xercesc/util/BinInputStream.hpp>
#include "../../util/platform.h"

namespace {
  using namespace xercesc;

  class IStreamBinInputStream : public xercesc::BinInputStream {
  public:
    IStreamBinInputStream(std::istream &istm) : istm_(istm), pos_(0) { }
    
    virtual unsigned int curPos () const;
    virtual unsigned int readBytes(XMLByte *const toFill, const unsigned int maxToRead);
  private:
    std::istream &istm_;
    unsigned int pos_;
  };

  unsigned int IStreamBinInputStream::curPos () const {
    return pos_;
  }
  unsigned int IStreamBinInputStream::readBytes(XMLByte *const toFill, 
						const unsigned int maxToRead) {

    unsigned int size = aka2::readsome(istm_, reinterpret_cast<char*>(toFill), maxToRead);
    pos_ += size;
    return size;
  }

}

using namespace aka2;

IStreamInputSource::IStreamInputSource(std::istream &istm) : istm_(istm){}

xercesc::BinInputStream *IStreamInputSource::makeStream() const {
  return new IStreamBinInputStream(istm_);
}

#endif
