/* -*- c++ -*- */
#ifndef AKAXISO2_XML_XERCES_XERCES_SERIALIZER_H__
#define AKAXISO2_XML_XERCES_XERCES_SERIALIZER_H__

/** 
 * @file akaxiso2/XML/xerces/xerces_serializer.h
 * @brief XML serializer/formatter by using Xerces-C++ transcoder.
 */

#include <akaxiso2/configuration.h>

#ifdef AKAXISO2_USE_XERCESC

#include <memory.h> /* {BCB6} */
#include <akaxiso2/util/scoped_ptr.h>
#include <akaxiso2/XML/serializer/formatter_base.h>
#include <akaxiso2/XML/serializer/xml_serializer_base.h>
#include <xercesc/util/TransService.hpp>

namespace aka2 {

  /** @brief Formatter with Xerces-C++ transcoder class. */
  class xerces_formatter : public formatter_base {
  public:
    xerces_formatter() 
      : in_transcoder_(0), out_transcoder_(0) {};
    virtual ~xerces_formatter() {}

  private:
    virtual void set_encoding(const std::string &encoding);
    virtual ustring lcp_to_ucs2(const std::string &source);
    virtual void write(const ustring &entity);
    void set_bom(const std::string &encoding);
    
    scoped_ptr<xercesc::XMLLCPTranscoder> in_transcoder_;
    scoped_ptr<xercesc::XMLTranscoder> out_transcoder_;
  };

  /** @brief XML serializer with Xerces-C++ transcoder class */
  class xerces_serializer : public xml_serializer_base {
  public:
    xerces_serializer(const std::string &encoding = AKAXISO2_DEFAULT_ENCODING)
    : xml_serializer_base(encoding) {
      formatter_ = shared_ptr<formatter_base>(new xerces_formatter());
      formatter_->set_encoding(encoding);
    }
  };

} // namespace aka2

#endif // AKAXISO2_USE_XERCESC


#endif
