/* -*- c++ -*- */
#include "akaxiso2.h"
#include "XML/serializer/formatter_base.h"
#include "framework/namespaces.h"
#include "framework/type_registry.h"
#include "framework/closure.h"
#include "framework/any.h"
#include "framework/namespace_statics.h"
#include "framework/any_op.h"
#include "framework/entity_complements.h"

#ifdef AKAXISO2_USE_XERCESC
#include <xercesc/util/PlatformUtils.hpp> /* {Xerces-C++} */
#endif

using namespace aka2;

namespace {
  type_registry     type_registry_;
  int init_count_ = 0;
}

namespace aka2 {
  extern entity_complements g_ecomp_;
  extern document_factory  g_doc_factory_;
}

entity_complements &aka2::system_entity_complements() {
  return g_ecomp_;
}

document_factory& aka2::system_document_factory() {
  return g_doc_factory_;
} 

type_registry &aka2::system_type_registry() {
  return type_registry_;
}


void aka2::initialize() {
  if (++init_count_ != 1)
    return;

#ifdef AKAXISO2_USE_BABEL
  babel::init_babel();
#endif

#ifdef AKAXISO2_USE_XERCESC
  xercesc::XMLPlatformUtils::Initialize();
#endif

  g_namespaces_ .initialize();
  g_doc_factory_  .clear();
  type_registry_.initialize();
  prefix_map    ::initialize();
  g_ecomp_.clear_all();
  g_pfs_ = &g_ecomp_.get_prefixes();
  wildcard_op        ::initialize();
  any_op  ::initialize();
  any_array_op  ::initialize();
}

void aka2::uninitialize() {
  if (init_count_ == 0 || --init_count_ != 0)
    return;

  any_op       ::uninitialize();
  any_array_op::uninitialize();
  g_namespaces_ .clear();
  g_ecomp_.clear_all();
  g_pfs_ = 0;
  g_doc_factory_  .clear();
  type_registry_.uninitialize();
  
#ifdef AKAXISO2_USE_XERCESC
  xercesc::XMLPlatformUtils::Terminate();
#endif
}
