/* -*- c++ -*- */
#ifndef AKAXISO2_FRAMEWORK_ELEMENT_PROPS_H__
#define AKAXISO2_FRAMEWORK_ELEMENT_PROPS_H__

/** @file akaxiso2/framework/occurrence.h */

#include <akaxiso2/util/shared_ptr.h>
#include <akaxiso2/util/iosfwd.h>
#include <akaxiso2/framework/qname.h>
#include <vector>

namespace aka2 {

  extern const int unbounded;

  struct occurrence {
    occurrence(int minOccurs = 1, int maxOccurs = 1)
      : minOccurs_(minOccurs), maxOccurs_(maxOccurs) {}
    int minOccurs_;
    int maxOccurs_;
    bool in_range(int count) const;
    bool is_array() const;
  };

  struct default_op {
    virtual void set_default(const std::string &defval) = 0;
    virtual bool has_default() const = 0;
    virtual const void *value() const = 0;
  };
  
  enum any_ns_type {
    ns_na = 0,
    ns_any,
    ns_other,
    ns_local,
    ns_uri
  };
  
  typedef std::vector<id_type> ns_ids;
  
  
  class element_props {
  public:
    element_props() : ns_type_(ns_na), emptiable_(false), op_(0) {}
    element_props(const element_op &op, bool emptiable) 
      : ns_type_(ns_na), emptiable_(emptiable), op_(&op) {}
    void set_occurrence(int minOccurs, int maxOccurs) { occ_ = occurrence(minOccurs, maxOccurs); }
    void set_occurrence(const occurrence &occ) { occ_ = occ; }
    const occurrence &get_occurrence() const { return occ_; }
    //const default_op& get_default() const { return *default_; }
    void set_name(const qname &name){ name_ = name; }
    const qname &get_name() const  { return name_; }

    bool is_emptiable() const { return emptiable_; }
    void check_emptiable();

    /**
     * methods when @fixed is specified.
     */
    bool is_fixed_string(const std::string &val, entity_complements &ecomp) const;
    void write_fixed_string(std::ostream &ostm, entity_complements &ecomp) const;
    void set_default_op(default_op *defop);

    void setup_default_value(const std::string &defval) { 
      default_->set_default(defval); 
    }

    schematype_id get_schematype() const {
      return op_->get_schematype();
    }

    const element_op& op() const { return *op_; }

    bool is_default_specified() const {
      if (default_.get() == 0)
	return false;
      return default_->has_default();
    }

    bool is_element() const { return name_.local()[0] != '&'; }

    void set_ns_list(const std::string &ns_list);
    bool is_any_name(const qname &tagname) const;
    any_ns_type ns_type_;
    id_type target_ns_id_;
    ns_ids ids_;
    bool emptiable_;
  protected:
    static bool check_emptiable_recursive(const element_props &props, const element_op &op);
    occurrence occ_;
    shared_ptr<default_op> default_;
    qname name_;
    const element_op *op_;

    /** Initialize member value to
     *    Given default value        : when @default is specified,
     *    Default construction value : when @default is not specified.
     *    Nothing to do              : when value is nill.
     */
    void set_default(void *e) const;
    bool is_default(const void *e) const;
  };

} // namespace aka2

#endif
