#include "model_check.h"


using namespace aka2;

bool aka2::check_occurrence(schematype_id id, const aka2::occurrence &occ) {
  if (id == array_id)
    return true;
  if (id == choice_id)
    return true;
  if (id == ptrmember_id)
    return is_ptrmember_occurrence(occ);
  if (!occ.is_array())
    return true;
  return false;
}

bool aka2::check_has_default(schematype_id id) {
  return  (id == simpletype_id) || (id == fixed_id);
}

bool aka2::is_ptrmember_occurrence(const aka2::occurrence &occ) {
  return ((occ.minOccurs_ == 0) || (occ.minOccurs_ == 1))
    && (occ.maxOccurs_ == 1);
}

bool aka2::is_all_occurrence(const aka2::occurrence &occ) {
  return ((occ.minOccurs_ == 0) || (occ.minOccurs_ == 1))
    && (occ.maxOccurs_ == 1);
}


void aka2::unknown_tagname_error(const std::string &tagname) {
  throw tagged_error("choice element", tagname, "is not registered", __FILE__, __LINE__);
}


void aka2::check_emptiable(member_types &mtypes) {
  for (member_types::iterator it = mtypes.begin();
       it != mtypes.end(); ++it)
    it->check_emptiable();
}

void aka2::check_emptiable(member_map &mmap) {
  for (member_map::iterator it = mmap.begin();
       it != mmap.end(); ++it)
    it->second.check_emptiable();
}

void aka2::check_emptiable(item_types &itypes) {
  for (item_types::iterator it = itypes.begin();
       it != itypes.end(); ++it)
    it->second.check_emptiable();
}
