/* -*- c++ -*- -*/
#ifndef AKAXISO2_FRAMEWORK_XMLTYPE_H__
#define AKAXISO2_FRAMEWORK_XMLTYPE_H__

/**
 * @file akaxiso2/framework/xmltype.h
 * @brief type name of serializable classes
 */

#include <akaxiso2/framework/qname.h>
#include <typeinfo>

namespace aka2 {

  /**
   * @brief XML type name for serializable classes 
   * @param L leaf class
   */
  template<class L>
  struct xmltype_statics {

    /**
     * @brief set type name.
     * @param name type name to set
     */
    static void xmltype(const std::string &name) {
      L::xmltype_ = aka2::qname(name);
    }

    /**
     * @brief get type name
     * @return type name set by xmltype(), or typeid(L).name() if type name is not specified yet, 
     */
    static std::string get_xmltype() {
      if (!L::xmltype_.empty())
	return L::xmltype_.qualified();
      return typeid(L).name();
    }
    static qname xmltype_; 
  };

  template<class L>
  qname xmltype_statics<L>::xmltype_;
}

#endif
