/* -*- c++ -*- */
#ifndef AKAXISO2_UTIL_IOSFWD_H__
#define AKAXISO2_UTIL_IOSFWD_H__

/** 
 * @file akaxiso2/util/iosfwd.h
 * @brief compiler-workaround for <iosfwd>
 */

#include <akaxiso2/configuration.h>
#include <iosfwd>

#ifdef MISSING_SSTREAM_IN_IOSFWD // for g++2.96
#include <akaxiso2/util/sstream.h>
#endif

/**
 * @class aka2::isstream
 * @brief Input stream of std::string.
 *
 * aka2::isstream is a typedef name of std::istringstream.\n
 * For g++2.95, aka2::isstream is a std::istrstream-derived class, 
 * because std::istringstream does not work.\n
 * aka2::isstream declaration for g++2.95 is shown as below.
 *
 * @code
 * namespace aka2 {
 *   class isstream : public std::istrstream {
 *   public:
 *     isstream(const std::string &str);
 * };
 * @endcode
 */ 

#ifdef AKAXISO2_USE_ISTRSTREAM //for g++2.95
namespace aka2 {
  class isstream;
}
#else
namespace aka2 {
  typedef std::istringstream isstream;
}
#endif

#endif
