/* -*- c++ -*- */
#ifndef MODEL_ARRAY_H__
#define MODEL_ARRAY_H__

#include <akaxiso2/content_model.h>
#include <string>
#include <vector>

struct model {
  std::string test_;
};

typedef std::vector<model> model_array;

struct root {
  model_array models_;
};


namespace xiso {

  /**
     <xs:complexType>
       <xs:sequence>
         <xs:sequence>
	   <xs:element name="test" type="xs:string" minOccurs="0" maxOccurs="unbounded"/>
	 </xs:sequence>
       <xs:sequence>
     </xs:complexType>
  */


  template<>
  struct leaf<model> : public aka::sequence<model> {
    void model() {
      member("test", &model::test_);
    }
  };

  template<>
  struct leaf<model_array> : public aka::sequential_array<model_array> {  };

  template<>
  struct leaf<root> : public aka::sequence<root> {
    void model() {
      member("&models", &root::models_, 0, aka::unbounded);
    }
  };

}


#endif
